"""Add workflow models

Revision ID: abb7ed8c56b4
Revises: 116891265c3a
Create Date: 2021-09-28 19:02:00.067155+00:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.engine.reflection import Inspector

# revision identifiers, used by Alembic.
revision = 'abb7ed8c56b4'
down_revision = '5cf9660bba80'
branch_labels = None
depends_on = None


def upgrade():

    conn = op.get_bind()
    inspector = Inspector.from_engine(conn)
    tables = inspector.get_table_names()

    if "action" in tables:
        op.rename_table('action', 'oldaction')
    if "condition" in tables:
        op.rename_table('condition', 'oldcondition')

    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('pipeline',
                    sa.Column('create_date', sa.DateTime(), nullable=True),
                    sa.Column('update_date', sa.DateTime(), nullable=True),
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('name', sa.String(), nullable=True),
                    sa.Column('description', sa.String(), nullable=False),
                    sa.Column('jobs_order', sa.String(), nullable=True),
                    sa.Column('enabled', sa.Boolean(), nullable=False),
                    sa.Column('running', sa.Boolean(), nullable=False),
                    sa.Column('creator_id', sa.Integer(), nullable=True),
                    sa.Column('update_user_id', sa.Integer(), nullable=True),
                    sa.Column('workspace_id', sa.Integer(), nullable=True),
                    sa.ForeignKeyConstraint(['creator_id'], ['faraday_user.id'], ondelete='SET NULL'),
                    sa.ForeignKeyConstraint(['update_user_id'], ['faraday_user.id'], ondelete='SET NULL'),
                    sa.ForeignKeyConstraint(['workspace_id'], ['workspace.id'], ),
                    sa.PrimaryKeyConstraint('id'),
                    sa.UniqueConstraint('name')
                    )
    op.create_index(op.f('ix_pipeline_workspace_id'), 'pipeline', ['workspace_id'], unique=False)
    op.create_table('workflow',
                    sa.Column('create_date', sa.DateTime(), nullable=True),
                    sa.Column('update_date', sa.DateTime(), nullable=True),
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('name', sa.String(), nullable=False),
                    sa.Column('description', sa.String(), nullable=False),
                    sa.Column('model', sa.Enum('vulnerability', 'vulnerability_web', 'host', 'service',
                                               name='valid_workflow_models'), nullable=False),
                    sa.Column('enabled', sa.Boolean(), nullable=False),
                    sa.Column('creator_id', sa.Integer(), nullable=True),
                    sa.Column('update_user_id', sa.Integer(), nullable=True),
                    sa.ForeignKeyConstraint(['creator_id'], ['faraday_user.id'], ondelete='SET NULL'),
                    sa.ForeignKeyConstraint(['update_user_id'], ['faraday_user.id'], ondelete='SET NULL'),
                    sa.PrimaryKeyConstraint('id'),
                    sa.UniqueConstraint('name')
                    )
    op.create_table('association_pipelines_and_jobs_table',
                    sa.Column('pipeline_id', sa.Integer(), nullable=True),
                    sa.Column('workflow_id', sa.Integer(), nullable=True),
                    sa.ForeignKeyConstraint(['pipeline_id'], ['pipeline.id'], ),
                    sa.ForeignKeyConstraint(['workflow_id'], ['workflow.id'], )
                    )
    op.create_table('action',
                    sa.Column('create_date', sa.DateTime(), nullable=True),
                    sa.Column('update_date', sa.DateTime(), nullable=True),
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('name', sa.String(), nullable=True),
                    sa.Column('description', sa.String(), nullable=False),
                    sa.Column('command', sa.String(), nullable=False),
                    sa.Column('field', sa.String(), nullable=True),
                    sa.Column('value', sa.String(), nullable=True),
                    sa.Column('custom_field', sa.Boolean(), nullable=False),
                    sa.Column('creator_id', sa.Integer(), nullable=True),
                    sa.Column('update_user_id', sa.Integer(), nullable=True),
                    sa.Column('workflow_id', sa.Integer(), nullable=True),
                    sa.ForeignKeyConstraint(['creator_id'], ['faraday_user.id'], ondelete='SET NULL'),
                    sa.ForeignKeyConstraint(['update_user_id'], ['faraday_user.id'], ondelete='SET NULL'),
                    sa.ForeignKeyConstraint(['workflow_id'], ['workflow.id'], ),
                    sa.PrimaryKeyConstraint('id')
                    )
    op.create_index(op.f('ix_action_workflow_id'), 'action', ['workflow_id'], unique=False)
    op.create_table('condition',
                    sa.Column('create_date', sa.DateTime(), nullable=True),
                    sa.Column('update_date', sa.DateTime(), nullable=True),
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('parent_id', sa.Integer(), nullable=True),
                    sa.Column('type', sa.Enum('and', 'or', 'xor', 'leaf', name='condition_types'), nullable=True),
                    sa.Column('field', sa.String(length=50), nullable=True),
                    sa.Column('operator', sa.String(length=50), nullable=True),
                    sa.Column('data', sa.String(length=50), nullable=True),
                    sa.Column('is_root', sa.Boolean(), nullable=False, default=False),
                    sa.Column('workflow_id', sa.Integer(), nullable=False),
                    sa.Column('creator_id', sa.Integer(), nullable=True),
                    sa.Column('update_user_id', sa.Integer(), nullable=True),
                    sa.ForeignKeyConstraint(['creator_id'], ['faraday_user.id'], ondelete='SET NULL'),
                    sa.ForeignKeyConstraint(['parent_id'], ['condition.id'], ),
                    sa.ForeignKeyConstraint(['update_user_id'], ['faraday_user.id'], ondelete='SET NULL'),
                    sa.ForeignKeyConstraint(['workflow_id'], ['workflow.id'], ),
                    sa.PrimaryKeyConstraint('id')
                    )
    op.create_index(op.f('ix_condition_workflow_id'), 'condition', ['workflow_id'], unique=False)
    op.create_table('workflow_execution',
                    sa.Column('create_date', sa.DateTime(), nullable=True),
                    sa.Column('update_date', sa.DateTime(), nullable=True),
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('successful', sa.Boolean(), nullable=False),
                    sa.Column('message', sa.String(), nullable=False),
                    sa.Column('workflow_id', sa.Integer(), nullable=False),
                    sa.Column('object_and_id', sa.String(), nullable=False),
                    sa.Column('creator_id', sa.Integer(), nullable=True),
                    sa.Column('update_user_id', sa.Integer(), nullable=True),
                    sa.ForeignKeyConstraint(['creator_id'], ['faraday_user.id'], ondelete='SET NULL'),
                    sa.ForeignKeyConstraint(['update_user_id'], ['faraday_user.id'], ondelete='SET NULL'),
                    sa.ForeignKeyConstraint(['workflow_id'], ['workflow.id'], ),
                    sa.PrimaryKeyConstraint('id')
                    )
    op.create_index(op.f('ix_workflow_execution_workflow_id'), 'workflow_execution', ['workflow_id'], unique=False)
    # ### end Alembic commands ###


def downgrade():

    conn = op.get_bind()
    inspector = Inspector.from_engine(conn)
    tables = inspector.get_table_names()

    op.drop_index(op.f('ix_workflow_execution_workflow_id'), table_name='workflow_execution')
    op.drop_table('workflow_execution')
    op.drop_index(op.f('ix_condition_workflow_id'), table_name='condition')
    op.drop_table('condition')
    op.drop_table('association_pipelines_and_jobs_table')
    op.drop_index(op.f('ix_action_workflow_id'), table_name='action')
    op.drop_table('action')
    op.drop_table('workflow')
    op.drop_index(op.f('ix_pipeline_workspace_id'), table_name='pipeline')
    op.drop_table('pipeline')
    if "oldaction" in tables:
        op.rename_table('oldaction', 'action')
    if "oldcondition" in tables:
        op.rename_table('oldcondition', 'condition')
    op.execute('DROP TYPE condition_types')
    op.execute('DROP TYPE valid_workflow_models')
    # ### end Alembic commands ###
