## A day in the life of a pentester: How I owned your domain in 4 hours

Arrived onsite, sat down, plugged in.

Started **Responder** (https://github.com/SpiderLabs/Responder), start **nbtscan**ning /24

- **Responder**: Spoofs **NBTNS** and **LLMNR** responses, get **NetNTLMv2** hashed passwords for domain users back in response
- **nbtscan** - Uses **NetBIOS** to get computer names/IPs from almost every host on subnet, very very quickly

> **Why**: The first step is to start gathering information about the environment. Most monitoring solutions will not detect nbtscan activity, and Responder is an easy win if their password policy is poor.

- - -

Cracked some creds gathered from Responder, and used **Metasploit’s smb_login** to check across subnet for local administrator.

> Why: Slow checking of valid credentials (one attempt every 30 seconds or so) with smb_login will show systems where the compromised credentials allow _Local Adminstrator access.

- - -

A couple systems had local admin from those creds, used local admin access to **psexec (executes a command or spawns a service, requires local admin or access to ADMIN$ share in Windows), spawn Cobalt Strike Beacons on those hosts.

- **Cobalt Strike** is an advanced red team framework, uses an implant called Beacon to control hosts.
- **Beacon** can communicate over **DNS**, **HTTPS**, **HTTP**, or **SMB**. In this case, I used HTTPS beacons. Additionally, we created a custom profile that makes Beacon traffic look like normal web browsing using the **Malleable C2** feature of Beacon. Raphael Mudge created Cobalt Strike, and has several examples of custom Beacon C2 profiles on his GitHub (https://github.com/rsmudge/Malleable-C2-Profiles)

> Why: I used this engagement to test out features of Cobalt Strike against a reasonably monitored network (I knew that the network is monitored, so I wanted to see how effective Cobalt Strike was for hiding my activity).

- - -

Use Beacons to run **Mimikatz** (integrated in Beacon), get plaintext credentials for users that have logged into the system recently. No domain admins yet.

- Mimikatz is a tool for attacking Windows secrets. Allows you to dump Kerberos secrets, create Golden Tickets, view plaintext credentials (if wdigest is enabled).

- - -

Ran BloodHound (https://github.com/adaptivethreat/BloodHound) to analyze Active Directory trust relationships, and find a path to the Domain Admins group. Showed several other systems across the domain that I could psexec to with the credentials I had.
Used Beacon’s SMB linking to spawn new Beacons to those systems, dumping cleartext credentials with Mimikatz on each of them. Only one compromised host actually talked to the internet, the rest just communicated through that single Beacon.

> Why: The fewer hosts sending odd traffic to the internet, the less suspicious you will be. Linking Beacons internally allowed me to control multiple hosts without having a system talking to the internet in an unusual manner.

**EXAMPLE** Beacon linked architecture:

```
                                              <---SMB---> Host 2 (SMB Beacon)
                                            /
C2 Server <---HTTPS---> Host 1 (HTTPS Beacon)<---SMB---> Host 3 (SMB Beacon)
                                            \
                                              <---SMB---> Host 4 (SMB Beacon)
```

One of those systems had cached credentials for a domain administrator. Used that to authenticate to Domain Controller, psexec to add Beacon link to DC, dumped hashes for entire domain.

- - -

**NEXT STEPS**: Time to hunt for valuable data! The pentest is not over when you get Domain Admin, you want to show the ramifications of compromising a Domain Admin, and find how to best demonstrate that to the customer.