/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericScriptObject;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSPackage;

public class GenericPackage
extends GenericObjectContainer
implements DBPQualifiedObject,
GenericScriptObject,
DBSPackage {
    private final GenericStructContainer container;
    private final String packageName;
    private final boolean nameFromCatalog;

    public GenericPackage(GenericStructContainer container, String packageName, boolean nameFromCatalog) {
        super(container.getDataSource());
        this.container = container;
        this.packageName = packageName;
        this.nameFromCatalog = nameFromCatalog;
        this.procedures = new ArrayList();
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.packageName;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.container;
    }

    @Override
    @Property(viewable=true, order=3, labelProvider=GenericCatalog.CatalogNameTermProvider.class)
    public GenericCatalog getCatalog() {
        return this.container.getCatalog();
    }

    @Override
    @Property(viewable=true, order=4)
    public GenericSchema getSchema() {
        return this.container.getSchema();
    }

    @Override
    public GenericStructContainer getObject() {
        return this;
    }

    @Override
    public List<GenericProcedure> getProcedures(DBRProgressMonitor monitor) throws DBException {
        return this.procedures;
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getCatalog(), this.getSchema(), this});
    }

    @Override
    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.procedures;
    }

    @Override
    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return (DBSObject)DBUtils.findObject((Collection)this.procedures, (String)childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return GenericProcedure.class;
    }

    @Override
    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.procedures.clear();
        return super.refreshObject(monitor);
    }

    public boolean isNameFromCatalog() {
        return this.nameFromCatalog;
    }

    @Override
    public void addProcedure(GenericProcedure procedure) {
        this.procedures.add(procedure);
    }

    public void orderProcedures() {
        DBUtils.orderObjects((List)this.procedures);
    }

    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        return null;
    }
}

