/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.ai;

import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.ai.AIContextSettings;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.internal.AIUIMessages;

public class AIUIUtils {
    private static final Log log = Log.getLog(AIUIUtils.class);

    private AIUIUtils() {
    }

    public static boolean confirmMetaTransfer(@NotNull AIContextSettings settings) {
        if (settings.isMetaTransferConfirmed()) {
            return true;
        }
        if (UIUtils.confirmAction((Shell)UIUtils.getActiveWorkbenchShell(), (String)AIUIMessages.confirm_meta_transfer_usage_title, (String)NLS.bind((String)AIUIMessages.confirm_meta_transfer_usage_message, (Object)settings.getDataSourceContainer().getName()), (DBPImage)DBIcon.AI)) {
            settings.setMetaTransferConfirmed(true);
            try {
                settings.saveSettings();
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError(AIUIMessages.confirm_meta_transfer_usage_title, null, (Throwable)e);
            }
            return true;
        }
        return false;
    }
}

