/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDValueRow;
import org.jkiss.dbeaver.model.data.hints.DBDAttributeHintProvider;
import org.jkiss.dbeaver.model.data.hints.DBDCellHintProvider;
import org.jkiss.dbeaver.model.data.hints.DBDValueHintContext;
import org.jkiss.dbeaver.model.data.hints.DBDValueHintProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.registry.data.hints.ValueHintContextConfiguration;
import org.jkiss.dbeaver.registry.data.hints.ValueHintProviderDescriptor;
import org.jkiss.dbeaver.registry.data.hints.ValueHintRegistry;
import org.jkiss.utils.CommonUtils;

public class ResultSetHintContext
implements DBDValueHintContext {
    private static final Log log = Log.getLog(ResultSetHintContext.class);
    private final Supplier<DBSDataContainer> dataContainerSupplier;
    private final Supplier<DBSEntity> entitySupplier;
    private final Map<String, Object> contextAttributes = new HashMap<String, Object>();
    private final Map<DBDValueHintProvider, HintProviderInfo> hintProviders = new IdentityHashMap<DBDValueHintProvider, HintProviderInfo>();
    private ValueHintContextConfiguration contextConfiguration;

    ResultSetHintContext(Supplier<DBSDataContainer> dataContainerSupplier, Supplier<DBSEntity> entitySupplier) {
        this.dataContainerSupplier = dataContainerSupplier;
        this.entitySupplier = entitySupplier;
    }

    @Nullable
    public DBSDataContainer getDataContainer() {
        return this.dataContainerSupplier.get();
    }

    @Nullable
    public DBSEntity getContextEntity() {
        return this.entitySupplier.get();
    }

    @Nullable
    public Object getHintContextAttribute(@NotNull String name) {
        return this.contextAttributes.get(name);
    }

    public void setHintContextAttribute(@NotNull String name, @Nullable Object value) {
        if (value == null) {
            this.contextAttributes.remove(name);
        } else {
            this.contextAttributes.put(name, value);
        }
    }

    public DBDValueHintContext.HintConfigurationLevel getConfigurationLevel() {
        return this.contextConfiguration.getLevel();
    }

    public void setConfigurationLevel(DBDValueHintContext.HintConfigurationLevel level) {
        DBSDataContainer dataContainer;
        DBDValueHintContext.HintConfigurationLevel oldLevel = this.getConfigurationLevel();
        if (oldLevel == level) {
            return;
        }
        if (level.ordinal() < oldLevel.ordinal()) {
            this.contextConfiguration.deleteConfiguration();
        }
        DBPDataSource ds = (dataContainer = this.getDataContainer()) == null || level == DBDValueHintContext.HintConfigurationLevel.GLOBAL ? null : dataContainer.getDataSource();
        DBSEntity entity = ds == null || level != DBDValueHintContext.HintConfigurationLevel.ENTITY ? null : this.entitySupplier.get();
        this.contextConfiguration = ValueHintRegistry.getInstance().getContextConfiguration(ds == null ? null : ds.getContainer(), entity, true);
        this.contextConfiguration.saveConfiguration();
    }

    public ValueHintContextConfiguration getContextConfiguration() {
        return this.contextConfiguration;
    }

    public Set<DBDValueHintProvider> getApplicableHintProviders() {
        return this.hintProviders.keySet();
    }

    public List<DBDCellHintProvider> getCellHintProviders(DBDAttributeBinding attr) {
        ArrayList<DBDCellHintProvider> result = new ArrayList<DBDCellHintProvider>();
        for (HintProviderInfo pi : this.hintProviders.values()) {
            if (!pi.enabled || !(pi.provider instanceof DBDCellHintProvider)) continue;
            DBDCellHintProvider chp = (DBDCellHintProvider)pi.provider;
            if (!pi.attributes.contains(attr)) continue;
            result.add(chp);
        }
        return result;
    }

    public List<DBDAttributeHintProvider> getColumnHintProviders(DBDAttributeBinding attr) {
        ArrayList<DBDAttributeHintProvider> result = new ArrayList<DBDAttributeHintProvider>();
        for (HintProviderInfo pi : this.hintProviders.values()) {
            if (!pi.enabled || !(pi.provider instanceof DBDAttributeHintProvider)) continue;
            DBDAttributeHintProvider ahp = (DBDAttributeHintProvider)pi.provider;
            if (!pi.attributes.contains(attr)) continue;
            result.add(ahp);
        }
        return result;
    }

    void resetCache() {
        this.contextAttributes.clear();
        this.hintProviders.clear();
    }

    void initProviders(DBDAttributeBinding[] attributes) {
        DBSDataContainer dataContainer = this.getDataContainer();
        DBPDataSource ds = dataContainer == null ? null : dataContainer.getDataSource();
        DBSEntity entity = ds == null ? null : this.entitySupplier.get();
        this.contextConfiguration = ValueHintRegistry.getInstance().getContextConfiguration(ds == null ? null : ds.getContainer(), entity, false);
        try {
            DBDAttributeBinding[] dBDAttributeBindingArray = attributes;
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                DBDAttributeBinding attr = dBDAttributeBindingArray[n2];
                ValueHintRegistry hintRegistry = ValueHintRegistry.getInstance();
                List attrHintProviders = hintRegistry.getAllValueBindings((Object)this, ds, (DBSTypedObject)attr, attr.getValueHandler().getValueObjectType((DBSTypedObject)attr));
                for (DBDValueHintProvider provider : attrHintProviders) {
                    HintProviderInfo providerInfo = this.hintProviders.computeIfAbsent(provider, p -> {
                        HintProviderInfo pi = new HintProviderInfo((DBDValueHintProvider)p);
                        ValueHintProviderDescriptor providerDescriptor = hintRegistry.getDescriptorByInstance(provider);
                        pi.enabled = this.contextConfiguration.isHintEnabled(providerDescriptor);
                        return pi;
                    });
                    providerInfo.attributes.add(attr);
                }
                ++n2;
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error loading hint providers", e);
        }
    }

    public void cacheRequiredData(@NotNull DBRProgressMonitor monitor, @Nullable Collection<DBDAttributeBinding> attributes, @NotNull Collection<? extends DBDValueRow> rows, boolean cleanupCache) throws DBException {
        for (HintProviderInfo pi : this.hintProviders.values()) {
            if (!pi.enabled || !(pi.provider instanceof DBDCellHintProvider)) continue;
            DBDCellHintProvider chp = (DBDCellHintProvider)pi.provider;
            chp.cacheRequiredData(monitor, (DBDValueHintContext)this, !CommonUtils.isEmpty(attributes) ? attributes : pi.attributes, rows, cleanupCache);
        }
    }

    static class HintProviderInfo {
        final DBDValueHintProvider provider;
        boolean enabled;
        final Set<DBDAttributeBinding> attributes = new LinkedHashSet<DBDAttributeBinding>();

        private HintProviderInfo(DBDValueHintProvider provider) {
            this.provider = provider;
        }
    }
}

