/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.registry;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLException;
import org.xml.sax.Attributes;

public class SQLQueryParameterRegistry {
    private static final Log log = Log.getLog(SQLQueryParameterRegistry.class);
    public static final String CONFIG_FILE_NAME = "parameter-bindings.xml";
    public static final String TAG_PARAMETER = "parameter";
    private static SQLQueryParameterRegistry registry;
    private final Map<String, ParameterInfo> parameterMap = new LinkedHashMap<String, ParameterInfo>();

    private SQLQueryParameterRegistry() {
    }

    public static synchronized SQLQueryParameterRegistry getInstance() {
        if (registry == null) {
            registry = new SQLQueryParameterRegistry();
            registry.loadParameters();
        }
        return registry;
    }

    public List<ParameterInfo> getAllParameters() {
        return new ArrayList<ParameterInfo>(this.parameterMap.values());
    }

    public ParameterInfo getParameter(String name) {
        return this.parameterMap.get(name);
    }

    public void setParameter(String name, String value) {
        this.parameterMap.put(name, new ParameterInfo(name, value));
    }

    public void deleteParameter(String name) {
        this.parameterMap.remove(name);
    }

    private void loadParameters() {
        Path storeFile = DBWorkbench.getPlatform().getLocalConfigurationFile(CONFIG_FILE_NAME);
        if (!Files.exists(storeFile, new LinkOption[0])) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (InputStream is = Files.newInputStream(storeFile, new OpenOption[0]);){
                SAXReader parser = new SAXReader(is);
                try {
                    parser.parse((SAXListener)new ParametersParser());
                }
                catch (XMLException ex) {
                    throw new DBException("Parameters binding parse error", (Throwable)ex);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (DBException ex) {
            log.warn((Object)("Can't load parameters binding from " + String.valueOf(storeFile)), (Throwable)ex);
        }
        catch (IOException ex) {
            log.warn((Object)"IO error", (Throwable)ex);
        }
    }

    public void save() {
        Path storeFile = DBWorkbench.getPlatform().getLocalConfigurationFile(CONFIG_FILE_NAME);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (OutputStream os = Files.newOutputStream(storeFile, new OpenOption[0]);){
                XMLBuilder xml = new XMLBuilder(os, GeneralUtils.UTF8_ENCODING);
                xml.setButify(true);
                xml.startElement("bindings");
                for (ParameterInfo param : this.parameterMap.values()) {
                    xml.startElement(TAG_PARAMETER);
                    xml.addAttribute("name", param.name);
                    xml.addAttribute("value", param.value);
                    xml.endElement();
                }
                xml.endElement();
                xml.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            log.warn((Object)"IO error", (Throwable)ex);
        }
    }

    public static class ParameterInfo {
        public String name;
        public String value;

        public ParameterInfo(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    private class ParametersParser
    implements SAXListener {
        private String curParameterName;
        private String curParameterValue;
        private StringBuilder legacyParameterValue = new StringBuilder();

        private ParametersParser() {
        }

        public void saxStartElement(SAXReader reader, String namespaceURI, String localName, Attributes atts) throws XMLException {
            if (localName.equals(SQLQueryParameterRegistry.TAG_PARAMETER)) {
                this.curParameterName = atts.getValue("name");
                this.curParameterValue = atts.getValue("value");
            }
        }

        public void saxText(SAXReader reader, String data) throws XMLException {
            if (this.curParameterName != null) {
                this.legacyParameterValue.append(data);
            }
        }

        public void saxEndElement(SAXReader reader, String namespaceURI, String localName) throws XMLException {
            if (localName.equals(SQLQueryParameterRegistry.TAG_PARAMETER) && this.curParameterName != null) {
                if (this.curParameterValue == null) {
                    Object legacyValue = this.legacyParameterValue.toString().trim();
                    if (!((String)legacyValue).isEmpty() && Character.isLetter(((String)legacyValue).charAt(0))) {
                        legacyValue = "'" + (String)legacyValue + "'";
                    }
                    this.curParameterValue = legacyValue;
                }
                SQLQueryParameterRegistry.this.parameterMap.put(this.curParameterName, new ParameterInfo(this.curParameterName, this.curParameterValue));
                this.curParameterName = null;
                this.legacyParameterValue.setLength(0);
            }
        }
    }
}

