#!/bin/bash

. ../MasterTest.sh

# Clean
CleanFiles ncr.in nc.rst7* text.rst7*

TESTNAME='NetCDF restart tests'
Requires netcdf maxthreads 1

INPUT="ncr.in"
# Test 1-1: Convert text to netcdf restart
TOP="../tz2.parm7"
cat > ncr.in <<EOF
noprogress
trajin ../tz2.rst7
trajout nc.rst7 ncrestart title "trajectory generated by ptraj"
EOF
RunCpptraj "NetCDF Restart Test - TXT->NetCDF"
# Test 1-2: Convert netcdf to text restart
cat > ncr.in <<EOF
noprogress
trajin nc.rst7
# time0 of -1 means dont write time
trajout text.rst7 restart title "trajectory generated by ptraj" time0 -1 
EOF
RunCpptraj "NetCDF Restart Test - NetCDF->TXT"
# Tell test to ignore whitespace, this fixes mismatch in title line,
# cpptraj always writes out 80 chars
DoTest ../tz2.rst7 text.rst7 -w

# Test 2-1: Convert text restart w/ box coords to nc restart
TOP="../tz2.ortho.parm7"
cat > ncr.in <<EOF
trajin ../tz2.ortho.rst7
trajout nc.rst7 ncrestart
EOF
RunCpptraj "NetCDF Restart w/ box Test - Txt->NetCDF"
# Test 2-2: Convert netcdf restart w/ box back to text
cat > ncr.in <<EOF
trajin nc.rst7
trajout text.rst7 restart title "Cpptraj Generated Restart"
EOF
RunCpptraj "NetCDF Restart w/ box Test - NetCDF->Txt"
DoTest ../tz2.ortho.rst7 text.rst7 -w

EndTest

exit 0
