/* clean the settings file */

suntanDir = strip(sysini("User", 'Suntan Special', 'Settings'), 'T', d2c(0))
settingsFile = suntanDir || '\settings.txt'
if stream(settingsFile, 'c', 'query exists') = '' then do
   call LogCdi "Error: settings file" settingsFile "does not exist"
   return 1
end

i = 0
do while lines(settingsFile) > 0
   sf.i = linein(settingsFile)
   i = i + 1
end
sf.0 = i
call stream settingsFile, 'c', 'close'

do i = 1 to sf.0
   parse var sf.i sname '=' svalue
   if QuerySettings(sname, 'Instructions') = 'syntax error' then do
      sf.i = 'XXX'
   end
end

all = QuerySettings('All')
do while all <> ''
   parse var all aname ';' all
   found = 0
   do i = 1 to sf.i
      parse var sf.i sname '=' svalue
      if aname = sname then found = 1
   end
   if found = 0 then do
      i = sf.0 + 1
      sf.i = aname || '=' || QuerySettings('DefaultValue'))
      sf.0 = i
   end
end

call SysFileDelete settingsFile
do i = 1 to sf.0
   if sf.i <> 'XXX' then do
      call lineout settingsFile, sf.i
   end
end
call stream settingsFile, 'c', 'close'
return 0
