/* install Suntan Special
 * This program is intended to be called from Suntan Special
 *
 * Description
 *   This command installs Suntan Special version 0.68.
 *
 * Copyright (C) 2018 Blonde Guy
 * All Rights Reserved
 */

productName = 'Suntan Special'
productDate = '2019-12-24 07:29:58'
productCategory = 'Application'
productURL = 'http://www.blondeguy.com/suntan6.html'

appsDir = arg(1)
chooser = arg(2)
installDir = appsDir || '\Suntan'
originalDir = Directory()
tempDir = value('TEMP',,'OS2ENVIRONMENT')
suntanDir = cdglobal('suntanDir')
oSetupDir = Directory('..')
oUtilDir = Directory('..\cdutils')
editionFile = oUtilDir || '\edition.dat'
if stream(editionFile, 'c', 'query exists') = '' then do
   editionFile = suntanDir || '\edition.dat'
end
editionString = linein(editionFile)
parse var editionString editionName ', version' editionVersion
call stream editionFile, 'c', 'close'

call Directory originalDir
upgradeInstallation = (translate(suntanDir) = translate(installDir))
cr = d2c(13)
cdCopy = 0
sunVer = '0.68'

if upgradeInstallation then do
   call LogCdi "Suntan Special Upgrade Installer"
   call LogCdi "upgrading product in" suntanDir "to version" sunVer
   
   if upgradeScreen() then do
      call LogCdi "User ended installation after upgrade screen."
      return 1
   end

   urc = doInstall()
   if urc <> 0 then do
      call LogCdi "Error" urc "installing" productName
   end
   else do
      call successScreen
   end
   return urc
end

call LogCdi "Suntan Special Full Installer"
call LogCdi "SuntanDir" suntanDir
call LogCdi "TempDir" tempDir

if welcomeScreen() then do
   call LogCdi "User ended installation after welcome screen."
   iniDeleteStatus = SysIni('User', 'Suntan Special', 'Settings', 'DELETE:')
   return 1
end

if licenseScreen() then do
   call LogCdi "User ended installation after license screen."
   iniDeleteStatus = SysIni('User', 'Suntan Special', 'Settings', 'DELETE:')
   return 1
end

if settingsFileScreen() then do
   call LogCdi "User ended installation after settings file screen."
   iniDeleteStatus = SysIni('User', 'Suntan Special', 'Settings', 'DELETE:')
   return 1
end

call applicationDirScreen

if translate(suntanDir) <> translate(installDir) then do
   /* change suntanDir to tempDir */
   /* move appdb.txt and cd-log.txt to tempDir */
   if fixSuntanDir() then return 1
end

call setupDirScreen

if editionName <> 'Web' then do
   call softwareRepositoryScreen
end

if installNowScreen() then do
   call LogCdi "User ended installation after install now screen."
   return 1
end

if doInstall() then do
   call LogCdi "Error" rc "installing Suntan Special"
   return 1
end

return 0


/* Upgrade screen */
upgradeScreen:

dialogName = "Welcome"
dialogText = "Upgrade to Suntan Special" editionName "edition, version" sunver || "." || cr || cr ||,
             "Suntan Special will be upgraded and 7 applications will",
             "be copied to the Setup directory." || cr || cr ||,
             "Suntan Special Installation directory:" suntanDir  || cr ||,
             "Suntan Special Setup directory:" cdglobal("setupDir") || cr || cr ||,
             "Select Install to proceed with the installation or",
             "select Remove to remove the existing installation or",
             "select Exit Now! to leave the current Suntan Special installation as it is."
rc = choice(dialogName, dialogText, "Upgrade", "Upgrade", "Remove", "Exit Now!")
if rc = "Exit Now!" then do
   return 1
end
else if rc = "Remove" then do
   call doRemove
   return 1
end

call LogCdi "Upgrade to Suntan Special version" sunver
return 0


/* Welcome screen */
welcomeScreen:

dialogName = "Welcome"
dialogText = "Welcome to Suntan Special version" sunver || "." || cr || cr ||,
             "The next screens will lead you through the installation of",
             "Suntan Special. You will specify the applications directory,",
             "and Suntan Special will be installed in a directory named",
             "suntan in that directory." || cr || cr ||,
             "Select continue to proceed with the installation or select",
             "Exit Now! to end this installation program."
rc = choice(dialogName, dialogText, "Continue", "Continue", "Exit Now!")
if rc \= "Continue" then do
   return 1
end

call LogCdi "Welcome to Suntan Special version" sunver
return 0


/* license screen */
licenseScreen:

dialogName = "License"
dialogText = "Suntan Special License Agreement" cr || cr ||,
             "Suntan Special is licensed software. The license agreement is named",
             "LICENSE.TXT and is located in the root directory of the CD-Rom. You",
             "must agree to the terms of the license in order to install Suntan Special."
rc = choice(dialogName, dialogText, "I Agree", "I Agree", "Exit Now!")
if rc \= "I Agree" then do
   return 1
end

call LogCdi "Thank-you for agreeing to the terms of the Suntan Special license."
return 0


/* settings file screen */
settingsFileScreen:

dialogName = "Settings File"
dialogText = "Choose source of settings" cr || cr ||,
             "Suntan Special uses a settings file to operate."
settingsFile = suntanDir || '\settings.txt'

if upgradeInstallation then do
   dialogText = dialogText "The settings from the currently installed",
                "Suntan Special are the suggested default."
end
else do
   dialogText = dialogText "The built-in settings are the suggested",
                "default."
end

dialogText = dialogText "You can use the suggested default, or use one",
             "that you write yourself. Before using Suntan Special for the",
             "first time, it is suggested to examine and edit the settings." || cr || cr ||,
             "Enter a blank settings file to exit from the installer."
settingsFile = query(dialogName, settingsFile, dialogText, 'File')
if settingsFile = '' then do
   call LogCdi "The user chose to terminate installation."
   return 1
end
if stream(settingsFile, 'c', 'query exists') = '' then do
   call LogCdi "settings file" settingsFile "does not exist."
   call SysSleep 4
   return settingsFileScreen()
end
call LogCdi "Settings to be determined by" settingsFile

if upgradeInstallation then do
   rc = copyfile(settingsFile, suntanDir || '\settings.txt')
   if rc <> 0 then do
      call LogCdi "Error" rc "copying" settingsFile "to" suntanDir
      return 1
   end
   call LogCdi "copied" settingsFile "to" suntanDir || '\settings.txt'
end
else do
   rc = copyfile(settingsFile, tempDir || '\settings.txt')
   if rc <> 0 then do
      call LogCdi "Error" rc "copying" settingsFile "to" tempDir || '\settings.txt'
      return 1
   end
   call LogCdi "copied" settingsFile "to" tempDir
end

return 0



/* Application directory screen */
applicationDirScreen:

appsDir = value('PROGRAMS',,'OS2Environment')
if appsDir <> '' then do
   call LogCdi "updating appsDir to" appsDir
   call setsetting 'appsDir', appsDir
end

longnameSupport = 0
do while longnameSupport = 0
   appsDir = QuerySettings('appsDir', 'Query')

   testDir = appsDir || '\suntanxxx'
   rc = sysmkdir(testDir)
   if rc <> 0 then do
      call LogCdi 'Suntan Special encountered error' rc 'while using' appsDir
   end
   else do
      longnameSupport = 1
   end
   call sysrmdir testDir   
end
call setsetting 'appsDir', appsDir
appsDir = QuerySettings('appsDir', 'Value')
installDir = appsDir || '\Suntan'
call LogCdi "Application Directory (appsDir) =" appsDir

return 0

/* remove suntan special and temporary files */
doRemove:
suntanDir = SysIni('User', 'Suntan Special', 'Settings')
if suntanDir <> 'ERROR:' then do
   call LogCdi "Suntan Special entry found in OS2.INI" suntanDir
   rc = SysIni('User', 'Suntan Special', 'Settings', 'DELETE:')
   if rc = '' then do
      call LogCdi "Suntan Special entry in OS2.INI successfully removed."
   end
   else do
      call LogCdi "Error removing Suntan Special from OS2.INI"
   end
end
else do
   call LogCdi "No entry found for Suntan Special in OS2.INI"
   appsDir = value('PROGRAMS',,'OS2ENVIRONMENT')
   if appsDir <> '' then do
      suntanDir = appsDir || '\suntan'
   end
end

call SysFileTree suntanDir, 'tdir.', 'DO'
if tdir.0 > 0 then do
   call LogCdi "Found Suntan Special directory"
   rc = SysDestroyObject(suntanDir)
   if rc = 1 then do
      call LogCdi "Suntan Special directory destroyed" suntanDir
   end
   else do
      call LogCdi "Error destroying Suntan Special Directory" suntanDir
   end
end
else do
   call LogCdi "Suntan Special installation was not found" suntanDir
end

tempDir = value('TEMP',,'OS2ENVIRONMENT')
if tempDir = '' then do
   tempDir = value('TMP',,'OS2ENVIRONMENT')
end
if tempDir = '' then do
   call LogCdi "No TEMP variable found in environment"
end
else do
   suntanTempDir = tempDir || '\suntan'
   call SysFileTree suntanTempDir, 'tdir.', 'DO'
   if tdir.0 > 0 then do
      call LogCdi "Found Suntan Special temp directory"
      rc = SysDestroyObject(suntanTempDir)
      if rc = 1 then do
         call LogCdi "Suntan Special temp directory destroyed" suntanTempDir
      end
      else do
         call LogCdi "Error destroying Suntan Special Temp Directory" suntanTempDir
      end
      tempSetup = tempDir || '\setup'
      rc = SysDestroyObject(tempSetup)
      if rc = 1 then do
         call LogCdi "Suntan Special temp Setup directory destroyed" tempSetup
      end
      else do
         call LogCdi "Error destroying Suntan Special temp Setup Directory" tempSetup
      end
      tempSettings = tempDir || '\Settings.Cdi'
      rc = SysDestroyObject(tempSettings)
      if rc = 1 then do
         call LogCdi "Suntan Special temp settings destroyed" tempSettings
      end
      else do
         call LogCdi "Error destroying Suntan Special temp settings" tempSettings
      end
   end
   else do
      call LogCdi "Suntan Special temp directory was not found" suntanTempDir
   end
end

call LogCdi "Suntan Special has been removed."
return

/* change suntanDir to tempDir */
/* move appdb.txt and cd-log.txt to tempDir */
fixSuntanDir:

if suntanDir <> tempDir then do
   dialogName = "Suntan Special Directory"
   dialogText = dialogName cr || cr ||,
                "Suntan Special will be installed in" installDir cr || cr ||,
                "A prior copy of Suntan Special was found in" suntanDir cr || cr ||,
                "The settings, application database and log file will be moved from",
                "the prior directory to the install directory."
   rc = choice(dialogName, dialogText, "continue", "continue", "Exit Now!")
   if rc \= "continue" then do
      return 1
   end   
end

appFile = suntanDir || '\cd-log.txt'
if stream(appFile, 'c', 'query exists') <> '' then do
   rc = copyfile(appFile, tempDir)
   if rc <> 0 then do
      call LogCdi "Error" rc "copying log file from" suntanDir
      return 1
   end
end

appFile = suntanDir || '\appdb.txt'
if stream(appFile, 'c', 'query exists') <> '' then do
   rc = copyfile(appFile, tempDir)
   if rc <> 0 then do
      call LogCdi "Error" rc "copying application database from" suntanDir
      return 1
   end
end

iniDeleteStatus = SysIni('User', 'Suntan Special', 'Settings', 'DELETE:')
iniSetStatus = SysIni('User', 'Suntan Special', 'Settings', tempDir || d2c(0))
if iniDeleteStatus <> '' | iniSetStatus <> '' then do
   call LogCdi "Error updating user profile."
end
suntanDir = tempDir

return 0



/* setup directory screen */
setupDirScreen:

setupDir = QuerySettings('setupDir', 'Query')
call SetSetting 'setupDir', setupDir
setupDir = QuerySettings('setupDir', 'Value')
call LogCdi "Setup Directory (setupDir) =" setupDir

return 0


/* install from CD or install from hard drive */
softwareRepositoryScreen:

dialogName = "Software Repository"
dialogText = "Suntan Special can create a software repository by copying all of",
             "the software installer files from the Suntan Special CD-ROM (or DVD) to",
             "the hard drive. Suntan Special will run more quickly from a software",
             "repository. You may add files that you obtain yourself to",
             "this software repository. Suntan Special will copy the CD-ROM (or DVD) to",
             "the directory specified by the setupDir setting."
datasource = choice(dialogName, dialogText, "Install from CD-ROM", "Install from CD-ROM", "Set up software repository")
cdCopy = (datasource = "Set up software repository")
call LogCdi "Application installation type:" datasource

return 0


installNowScreen:

driveinfo = SysDriveInfo(filespec('Drive', appsDir))
parse var driveinfo drive free total label

/* format freebytes with commas */
freebytes = ''
if length(free) > 12 then do
   freebytes = left(free, length(free)-12) || ','
   free = right(free, 12)
end
if length(free) > 9 then do
   freebytes = left(free, length(free)-9) || ','
   free = right(free, 9)
end
if length(free) > 6 then do
   freebytes = freebytes || left(free, length(free)-6) || ','
   free = right(free, 6)
end
if length(free) > 3 then do
   freebytes = freebytes || left(free, length(free)-3) || ','
   free = right(free, 3)
end
freebytes = freebytes || free

dialogName = "Install Now"
dialogText = "Suntan Special is ready to install. The directory you have",
             "chosen for applications," appsDir || ", is on drive" drive,
             "which has" freebytes "bytes free. Suntan Special will be",
             "installed in" appsDir || "\Suntan."
rc = choice(dialogName,,
            dialogText,,
            "Install Now",,
            "Install Now",,
            "Exit")

if rc = 'Exit' then do
   call LogCdi "Discarding changes and exiting."
   return 1
end

return 0


/* copy one file
   arg(1) is the source File
   arg(2) is the target Directory
*/
copyfile:
sourceFile = arg(1)
targetDir = arg(2)
sFile = stream(sourceFile, 'c', 'query exists')
if sFile = '' then do
   call LogCdi "file not found" sourceFile
   return 1
end

if translate(sourceFile) = translate(targetDir) then return 0

sDir = strip(filespec('Drive', sFile) || filespec('Path', sFile), 't', '\')
tDir = directory(targetDir)
if translate(sDir) = translate(tDir) then do
   return 0
end
address cmd '@copy "' || sourceFile || '" "' || targetDir || '"> nul'
if rc <> 0 then do
   say "Error" rc "copying" sourceFile "to" targetDir
   say "Current Directory is" Directory()
end
return rc


doInstall:

rc = SuntanMkDir(installDir)
if rc = 0 then do
   call LogCdi "Created installation directory" installDir
end
else if rc <> 5 then do
   call LogCdi "Error" rc "creating installation directory"
   return 1
end

if stream(installDir || '\suntan.exe', 'c', 'query exists') <> '' then do
   address cmd '@unlock' installDir || '\suntan.exe'
   if rc <> 0 then do
      call LogCdi "Error" rc "unlocking Suntan Special Display Monitor"
   end
   else do
      call LogCdi "Suntan Special Display Monitor unlocked"
   end
end

call SysFileTree installDir || '\*.seq', 'userseq.', 'FO'
if userseq.0 > 0 then do
   archiveDir = installDir || '\archived'
   call SuntanMkDir(archiveDir)
   do i=1 to userseq.0
      call copyfile userseq.i, archiveDir
   end
   call LogCdi userseq.0 "sequences archived to" archiveDir
end

/* handle global unzip */
address cmd '@unzip --version'
if rc <> 0 then do
   global_unzip = 1
end
else do
   global_unzip = 0
end

call Directory originalDir
call LogCdi "unzipping from" originalDir "to" installDir
address cmd '@unzip -q -o suntan068.zip -d' installDir '-x settings.txt'
if rc <> 0 then do
   call LogCdi "Error" rc "unpacking product files" 
   return 1
end

if tempDir = suntanDir then do
   /* copy files from tempDir */
   logFile = tempDir || '\cd-log.txt'
   if stream(logFile, 'c', 'query exists') <> '' then do
      rc = copyfile(logFile, installDir)
      if rc <> 0 then do
         call LogCdi "Error" rc "copying log file from" tempDir
      end
   end

   appFile = tempDir || '\appdb.txt'
   if stream(appFile, 'c', 'query exists') <> '' then do
      rc = copyfile(appFile, installDir)
      if rc <> 0 then do
         call LogCdi "Error" rc "copying application database file from" tempDir
      end
   end

   setFile = tempDir || '\settings.txt'
   if stream(setFile, 'c', 'query exists') <> '' then do
      rc = copyfile(setFile, installDir)
      if rc <> 0 then do
         call LogCdi "Error" rc "copying settings file from" tempDir
      end
   end

   /* set suntanDir */   
   iniDeleteStatus = SysIni('User', 'Suntan Special', 'Settings', 'DELETE:')
   iniSetStatus = SysIni('User', 'Suntan Special', 'Settings', installDir || d2c(0))
   if iniDeleteStatus <> '' | iniSetStatus <> '' then do
      call LogCdi "Error updating user profile."
   end
   suntanDir = installDir
end

if stream(installDir || '\settings.txt', 'c', 'query exists') = '' then do
   address cmd '@unzip -q -o suntan068.zip settings.txt -d' installDir
   if rc <> 0 then do
      call LogCdi "Error" rc "unpacking default settings"
      return 1
   end
   else do
      call LogCdi "Using default settings"
   end
end

call LogCdi "creating Suntan Special Folder"
bgFolderID = '<BG_SUNTANSPECIALFOLDER>'
rc = SysCreateObject('WPFolder', productName, '<WP_DESKTOP>',,
                     'OBJECTID=' || bgFolderID || ';OPEN=ICON',,
                     'UpdateIfExists')
if rc = 0 then do
   call LogCdi "Could not create product folder"
   bgFolderID = '<WP_DESKTOP>'
end
else do
   call ProgramFolder bgFolderID
end

call LogCdi "Creating program object for Display Monitor"
rc = SysCreateObject('WPProgram','Suntan Special',bgFolderID,,
        'EXENAME=' || installDir || '\suntan.exe' || ';' ||,
        'ICONFILE=' || installDir || '\suntan.ico;' ||,
        'OBJECTID=<BG_SUNTAN_MONITOR>;' ||,
        'STARTUPDIR=' || installDir || ';', 'UpdateIfExists')
if rc = 0 then do
   call LogCdi "Could not create program object"
end
else do
   call SysMoveObject '<BG_SUNTAN_MONITOR>', '<BG_SUNTANSPECIALFOLDER>'
end

call LogCdi "creating Blonde Guy URL object"
rc = SysCreateObject('WPUrl', 'Blonde Guy', bgFolderID,,
                     'OBJECTID=<BG_HOME_PAGE>;' ||,
                     'URL=http://www.blondeguy.com/;' ||,
                     'DEFAULTVIEW=CONTENTS',,
                     'UpdateIfExists')
if rc = 0 then do
   call LogCdi "Could not create Blonde Guy URL"
end
else do
   call SysMoveObject '<BG_HOME_PAGE>', '<BG_SUNTANSPECIALFOLDER>'
end

if AddBook("Suntan Special User Manual", installDir || '\suntan.inf', '<BG_SUNTANMANUAL>') <> 0 then do
   call LogCdi "Error, user manual icon not created."
end
else do
   call SysMoveObject '<BG_SUNTANMANUAL>', '<BG_SUNTANSPECIALFOLDER>'
end

setupDir = cdglobal('setupDir')
rc = SuntanMkDir(setupDir)
if rc <> 0 & rc <> 5 then do
   call LogCdi "Error" rc "creating setup directory" setupDir
   return 1
end

call Directory installDir

call LogCdi "Moving selected apps from" installDir "to" setupDir
rc = backupCopy('reboot')
rc = backupCopy('pause')
rc = backupCopy('archiveOn')
rc = backupCopy('archiveOff')
rc = backupCopy('SaveBootManager')
rc = backupCopy('RestoreBootManager')
rc = backupCopy('gcc4core')

call Directory originalDir

docTarget = installDir || '\doc'
call LogCdi "creating Suntan Special docs object"
docURL = translate('file:///' || docTarget || '/index.html','\','/')
rc = SysCreateObject('WPUrl', 'Suntan Special Documentation', bgFolderID,,
                     'OBJECTID=<BG_SUNTANDOC>;' ||,
                     'URL=' || docURL || ';' ||,
                     'DEFAULTVIEW=CONTENTS',,
                     'UpdateIfExists')
if rc = 0 then do
   call LogCdi "Could not create a documentation URL"
end
else do
   call SysMoveObject '<BG_SUNTANDOC>', '<BG_SUNTANSPECIALFOLDER>'
end

call SetSetting 'phoneUser', 'suntan-user'
call SetSetting 'phonePassword', 'OS2expert'
call SetSetting 'phoneHomeURL', 'ftp://ftp.blondeguy.com/SuntanV6/update.zip'
call SetSetting 'tempDir', tempDir

thepath = value('path',,'os2environment')
if pos(translate(installDir),translate(thepath)) > 0 then do
   queue 'ReadConfigFile'
   queue 'RemoveFromPath' installDir
   queue 'WriteConfigFile'
   queue 'exit'
   call EditConfigSys
   call LogCdi "Removed" installDir "from the PATH"
end

/* make sure setup dir is in source dir */
sourceDir = cdglobal('sourceDir')
found = 0
do while sourceDir <> ''
   parse var sourceDir myDir ';' sourceDir
   if translate(myDir) = translate(setupDir) then do
      found = 1
   end
end
sourceDir = cdglobal('sourceDir')

if found = 0 then do
   sourceDir = strip(sourceDir, 'Both', ';') || ';' || setupDir
   sourceDir = strip(sourceDir, 'Both', ';')
   call SetSetting 'sourceDir', sourceDir
   call LogCdi "Added setup directory to source dir"
end

/* remove ..\setup from source dir */
sourceDir = cdglobal('sourceDir')
found = 0
newSourceDir = ''
do while sourceDir <> ''
   parse var sourceDir myDir ';' sourceDir
   if translate(myDir) = '..\SETUP' then do
      found = 1
   end
   else do
      newSourceDir = newSourceDir || ';' || myDir
   end
end

if found = 1 then do
   sourceDir = strip(newSourceDir, 'Both', ';')
   call SetSetting 'sourceDir', sourceDir
   call LogCdi "Removed ..\setup from sourceDir"
end

/* remove temporary suntan directory from sourcedir */
suntanTempDir = value("SuntanTempDir", tempDir || '\setup', 'OS2ENVIRONMENT')
if suntanTempDir <> '' then do
   sourceDir = cdglobal('sourceDir')
   found = 0
   newSourceDir = ''
   do while sourceDir <> ''
      parse var sourceDir myDir ';' sourceDir
      if translate(myDir) = suntanTempDir then do
         found = 1
      end
      else do
         newSourceDir = newSourceDir || ';' || myDir
      end
   end
   
   if found = 1 then do
      sourceDir = strip(newSourceDir, 'Both', ';')
      call SetSetting 'sourceDir', sourceDir
      call LogCdi "Removed" suntanTempDir "from sourceDir"
   end
end

/* copy CD to software repository */
if cdCopy = 1 then do
   call SetSetting 'saveWebApps', '1'
   call LogCdi "Copying software repository from" oSetupDir
   address cmd '@xcopy' oSetupDir setupDir || '\ /s'
   if rc <> 0 then do
      call LogCdi "Error" rc "copying software repository"
      call LogCdi "from" cdSourceDir
      call LogCdi "to" setupDir
   end
   else do
      call LogCdi "Software repository copied to" setupDir
   end
end

/* install from CD */
else if chooser <> '' & editionName <> 'Web' then do
   sourceDir = cdglobal('sourceDir')
   found = 0
   do while sourceDir <> ''
      parse var sourceDir myDir ';' sourceDir
      if translate(myDir) = translate(oSetupDir) then do
         found = 1
      end
   end
   sourceDir = cdglobal('sourceDir')
   
   if found = 0 then do
      sourceDir = strip(sourceDir, 'Both', ';') || ';' || oSetupDir
      call SetSetting 'sourceDir', sourceDir
      call LogCdi "Added media directory to source dir:" oSetupDir
   end
end

call LogCdi "New source dir:" cdglobal('sourceDir')

/* handle global unzip */
if global_unzip = 1 then do
   unzipExe = installDir || '\unzip.exe'
   if stream(unzipExe, 'c', 'query exists') <> '' then do
      call LogCdi "Disabling Suntan Special internal copy of unzip.exe"
      address cmd '@del' installDir || '\unzip.exe > nul'
      if rc <> 0 then do
         call LogCdi "Error" rc "deleting unzip.exe"
      end
   end
end

/* don't close Suntan Special folder 
address cmd '@sendmsg "' || productName || '" WM_CLOSE' */

call ProgramFolder '<BG_SUNTANSPECIALFOLDER>'

call LogCdi productName "installation complete."
return 0


/* success screen */
successScreen:

cr = d2c(13)
if upgradeInstallation then do
   successStatus = "upgraded"
end
else do
   successStatus = "installed"
end
dialogText = "Suntan Special has been successfully" successStatus || "." || cr || cr || cr ||,
             "First steps:" || cr ||,
             "1. Examine and edit the settings." || cr ||,
             "2. Refresh the application list." || cr || cr ||,
             "Suntan Special will close in 10 seconds." || cr || cr ||,
             "After Suntan Special closes, start Suntan Special from its icon to continue."
             
response = messageDialog("Success", 6, dialogText)

address cmd '@start /min "Shutdown Suntan Special" shutsuntan.cmd'
call LogCdi "Operation complete."

return


/* make backup copy of application command */
backupCopy:
parse arg command

call SysFileTree '*.*', 'Apps', 'DO'

do i=1 to Apps.0
   if compare(translate(command), translate(filespec('name',Apps.i))) = 0 then do

      /* copy the command */
      targetDir = setupDir || '\' || command
      address cmd '@xcopy' Apps.i targetDir || '\ /s > nul'
      if rc <> 0 then do
         call LogCdi "Error" rc "copying" Apps.i "to" targetDir
      end
      else do
         call LogCdi "Command" command "moved from" Apps.i "to" targetDir
         address cmd '@deltree /y' command '> nul'
         if rc <> 0 then do
            call LogCdi "Error" rc "deleting temporary copy of command"
         end
      end
      return rc
   end
end

call LogCdi "Command not found" command
return -1
