/* timestamp a file
 * adds/replaces a line beginning with productDate =
 */

parse arg cmdFile

if cmdFile = '' then do
   say "usage: timestamp <cmdFile>"
   return
end

if stream(cmdFile, 'c', 'query exists') = '' then do
   say "file not found" cmdFile
   return
end

else do
   testLine = 'productName ='
   cmdDate = SysGetFileDateTime(cmdFile, "Write")
   newFile = cmdFile || '.1'
   call SysDestroyObject newFile
   do while lines(cmdFile)
      sline = linein(cmdFile)
      if pos(testLine, sline) = 1 then do
         call lineout newFile, 'productName =' substr(sline, 15)
         call lineout newFile, "productDate = '" || cmdDate || "'"
      end
      else if pos('productDate =', sline) <> 1 then do
         call lineout newFile, sline
      end
   end
   call stream cmdFile, 'c', 'close'
   call stream newFile, 'c', 'close'
   address cmd '@copy' newFile cmdFile '> nul'
   if rc <> 0 then do
      say "opps! error" rc "copying" newFile "to" cmdFile
   end
   if stream(newFile, 'c', 'query exists') <> '' then do
      address cmd '@del' newFile '> nul'
      call SysDestroyObject newFile
   end
   call SysSetFileDateTime cmdFile, word(cmdDate, 1), word(cmdDate, 2)
   say "Product Date in" cmdFile "set to" cmdDate
end

return
