/* startgui.cmd
 *
 * startgui <appName> [appParam]
 *   starts Suntan Special Display Monitor
 *   runs suntan special application appName with application
 *   parameter appParam, then closes display monitor
 *   if no argument is specified, just starts monitor
 *
 * Copyright (C) 2017 Blonde Guy
 * All Rights Reserved
 */

/* set up environment */
call 'cd-env'
pipeName = '\pipe\suntan'
command = arg(1)
argument = arg(2)

/* attempt to open pipe to display monitor */
pipestate = stream(pipeName, 'c', 'open')
if left(pipestate, 5) \= 'READY' then do
   address cmd '@start suntan.exe /n'

   /* wait for display monitor to be ready */
   do until left(pipestate, 5) = 'READY'
      call SysSleep 1
      pipestate = stream(pipeName, 'c', 'open')
   end
end
pipestate = stream(pipeName, 'c', 'close')

if command <> '' then do
   call installApp command argument
   address cmd '@sendmsg "Suntan Special Display Monitor" WM_CLOSE > nul'
end

return
