/* remove suntan
 *
 * Uninstall program for Suntan Special
 *
 * Copyright (C) 2019 Blonde Guy
 * All Rights Reserved
 */

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

say "Suntan Special Uninstallation Program"
say "Type REMOVE to uninstall Suntan Special"
pull ans
if translate(ans) <> 'REMOVE' then do
   say "Operation cancelled, nothing removed."
   return
end

suntanDir = SysIni('User', 'Suntan Special', 'Settings')
if suntanDir <> 'ERROR:' then do
   say "Suntan Special entry found in OS2.INI" suntanDir
   rc = SysIni('User', 'Suntan Special', 'Settings', 'DELETE:')
   if rc = '' then do
      say "Suntan Special entry in OS2.INI successfully removed."
   end
   else do
      say "Error removing Suntan Special from OS2.INI"
   end
end
else do
   say "No entry found for Suntan Special in OS2.INI"
   appsDir = value('PROGRAMS',,'OS2ENVIRONMENT')
   if appsDir <> '' then do
      suntanDir = appsDir || '\suntan'
   end
end

call SysFileTree suntanDir, 'tdir.', 'DO'
if tdir.0 > 0 then do
   say "Found Suntan Special directory"
   rc = SysDestroyObject(suntanDir)
   if rc = 1 then do
      say "Suntan Special directory destroyed" suntanDir
   end
   else do
      say "Error destroying Suntan Special Directory" suntanDir
   end
end
else do
   say "Suntan Special installation was not found" suntanDir
end

tempDir = value('TEMP',,'OS2ENVIRONMENT')
if tempDir = '' then do
   tempDir = value('TMP',,'OS2ENVIRONMENT')
end
if tempDir = '' then do
   say "No TEMP variable found in environment"
end
else do
   suntanTempDir = tempDir || '\suntan'
   call SysFileTree suntanTempDir, 'tdir.', 'DO'
   if tdir.0 > 0 then do
      say "Found Suntan Special temp directory"
      rc = SysDestroyObject(suntanTempDir)
      if rc = 1 then do
         say "Suntan Special temp directory destroyed" suntanTempDir
      end
      else do
         say "Error destroying Suntan Special Temp Directory" suntanTempDir
      end
      tempSetup = tempDir || '\setup'
      rc = SysDestroyObject(tempSetup)
      if rc = 1 then do
         say "Suntan Special temp Setup directory destroyed" tempSetup
      end
      else do
         say "Error destroying Suntan Special temp Setup Directory" tempSetup
      end
      tempSettings = tempDir || '\Settings.Cdi'
      rc = SysDestroyObject(tempSettings)
      if rc = 1 then do
         say "Suntan Special temp settings destroyed" tempSettings
      end
      else do
         say "Error destroying Suntan Special temp settings" tempSettings
      end
   end
   else do
      say "Suntan Special temp directory was not found" suntanTempDir
   end
end

say "operation complete"
return
