/* DoYum.cmd
 * run a yum command from Suntan Special
 *
 * Arguments
 *   arg(1) - command String
 *
 * Copyright (C) 2019 Blonde Guy
 * All Rights Reserved
 */

parse arg commandStr

if commandStr = '' then do
   call LogCdi "usage: doYum commandString"
   return 1
end

yrc = performYum(commandStr)

call LogCdi "doYum(" || commandStr || ") returned" yrc

return yrc


performYum:
parse arg commandStr

tempDir = value('TEMP',,'OS2ENVIRONMENT')
errfile = tempDir || '\yum.err'
originalDir = Directory()
call Directory tempDir
status = 'OK'
cr = d2c(13)
yumignorerpmdb = cdglobal('yumignorerpmdb')
do while status = 'OK'
   call LogCdi "executing yum" commandStr
   address cmd '@yum -y' commandStr '>' errfile '2>&1'
   yrc = rc
   dbfound = ''
   do while lines(errfile)
      thisline = linein(errfile)
      call LogCdi thisline
      if pos('Rpmdb checksum is invalid', thisline) > 0 then dbfound = 'An Rpmdb checksum problem was found.'
   end
   call stream errfile, 'c', 'close'
   if (yumignorerpmdb = 1) & (dbfound <> '') then do
      status = 'Continue'
      call LogCdi "ignoring Rpmdb error returned by yum"
   end
   else if rc <> 0 then do
      status = radiolist("Error", "The yum command did not complete successfully.",
                         "Check the log for additional information. " dbfound || cr ||,
                         "Select OK to repeat the command,",
                         "Cancel to abandon product installation, or",
                         "Continue to ignore the error and continue product installation.",,
                         "Enter choice:", "OK", "Cancel", "!Continue")
   end
   else do
      status = 'Done'
   end
end

call SysFileDelete errfile

if rc <> 0 then do
   if status = 'Continue' then do
      rc = 0
   end
end

call Directory originalDir
call LogCdi "yum completed, status:" status
return rc

