/* Message Dialog
 *
 * Present a message to the user, and wait for the user
 *
 * Arguments
 *   arg(1) - the dialog name. This will be the title line for VIO and the
 *            name of the tab on the Display Monitor.
 *   arg(2) - a flag for handling this message
 *            1 ... normal message
 *            2 ... don't wait after displaying message
 *            3 ... don't display message, just wait
 *            4 ... close the message page
 *            5 ... OK/Cancel message (returns OK or Cancel)
 *            6 ... Timed message (returns after OK or after 10 seconds)
 *   arg(3) - a string containing the query to the user. This string has
 *            a maximum length of 900 characters.
 *
 * Copyright (C) 2009 Blonde Guy
 * All Rights Reserved
 */

pipeName = '\pipe\suntan'
dialogName = 'Message Test'

if arg() = 0 then do
   response = messageDialog(dialogName, 5, "Testing the message screen.")
   say response
   exit
end

if arg() = 1 then do
   mdFlag = 1
end
else do
   mdFlag = arg(2)
end

call SysWaitNamedPipe pipename, -1
pipestate = stream(pipeName, 'c', 'open')
if left(pipestate, 8) = 'NOTREADY' then do
   if mdflag = 1 | mdflag = 2 | mdflag = 5 | mdflag = 6 then do
      dialogName = arg(1)
      say dialogName
      say ""
      call SayWords arg(3)
      say ""
      if mdflag = 5 then do
         say "Type Cancel and press Enter to cancel, or"
      end
      say "Press Enter to continue."
   end
   if mdflag = 6 then do
      starttime = time('e')
   end
   response = '   OK'
   if mdflag = 1 | mdflag = 3 | mdflag = 5 then do
      parse pull response
      if translate(response) = 'CANCEL' then do
         response = '   Cancel'
      end
      else do
         response = '   OK'
      end
   end
   else if mdflag = 6 then do
      response = '   Cancel'
      do i=1 to 10
         if queued() > 0 then do
            parse pull response
            if translate(response) = 'CANCEL' then do
               response = '   Cancel'
            end
            else do
               response = '   OK'
            end
         end
         else do
            call SysSleep 1
         end
      end
   end
end
else do /* display monitor is running */
   if mdflag = 1 | mdflag = 2 then do
      x = arg(1) || d2c(10) || arg(3)
   
      call lineout pipeName, "!message" x
      call SysSleep 1
   end
   else if mdflag = 5 then do
      x = arg(1) || d2c(10) || arg(3)
   
      call lineout pipeName, "!okcancel" x
      call SysSleep 1      
   end
   else if mdflag = 6 then do
      x = arg(1) || d2c(10) || arg(3)
   
      call lineout pipeName, "!timedmsg" x
      call SysSleep 1      
   end
   else do
      if mdflag = 4 then do
         call lineout pipeName, "!msgquit"
         call SysSleep 1
      end
   end
   
   response = ''
   if mdflag = 1 | mdflag = 3 | mdflag = 4 | mdflag = 5 | mdflag = 6 then do
      /* call SysSwitchSession "Suntan Special Display Monitor" not available in Warp 4 FP 0 */
      do until response \= ''
         pipeState = stream(pipeName, 'c', 'open')
         if left(pipeState, 8) = 'NOTREADY' then do
            call SysWaitNamedPipe pipeName, -1
            pipeState = stream(pipeName, 'c', 'open')
            if left(pipeState, 8) = 'NOTREADY' then return 'Pipe is not ready'
         end
         call lineout pipeName, "!dialogwait"
         response = linein(pipeName)
         call SysSleep 1
      end
   end
end

return substr(response, 4)
