/* set the cdLetter */
parse arg testDrive

oldCDLetter = cdglobal('cdLetter')
if left(testDrive, 1) = oldCDLetter then return left(testDrive, 1)

/* check if the source path needs to be modified */
sourcePath = cdglobal('sourceDir')
j = 0
do while sourcePath \= ''
   parse var sourcePath sourceDir ';' sourcePath
   if sourceDir \= '' then do
      j = j + 1
      Dir.j = sourceDir
   end
end
Dir.0 = j

sourcePathChanged = 0
if Dir.0 > 0 then do
   do j = 1 to Dir.0
      if left(Dir.j, 1) = oldCDLetter then do
         Dir.j = left(testDrive, 1) || substr(Dir.j, 2)
         sourcePathChanged = 1
      end
   end
   
   if sourcePathChanged = 1 then do
      sourcePath = Dir.1
      do j = 2 to Dir.0
         sourcePath = sourcePath || ';' || Dir.j
      end
   end
end

call SetSetting 'SourceDir', sourcePath
call SetSetting 'cdLetter', left(testDrive, 1)

if sourcePathChanged = 1 then do
   call LogCdi "SourceDir changed to" sourcePath
end

call LogCdi "Set cdLetter = '" || left(testDrive, 1) || "'"
return left(testDrive, 1)
