/* turn on the archive the desktop at system boot
 * This program is intended to be called from Suntan Special
 *
 * Description
 *   This command sets the computer to archive the desktop at system
 *   boot. There is a companion command, archiveOff, that sets the computer to
 *   NOT archive the desktop a system boot.
 *
 * Copyright (C) 2010 Blonde Guy
 * All Rights Reserved
 */

productName = 'Turn on Desktop Archive'
productDate = '2010-07-28 07:44:32'
productCategory = 'Configuration'

arcDir = FindBootDrive() || ':\os2\boot'
originalDir = Directory()
arcFile = 'ARCHBASE.$$$'
parse arg appsDir
semFile = appsDir || '\Suntan\archive.$$$'

call Directory arcDir
address cmd '@attrib -r' arcFile

rc = stream(arcFile, 'c', 'open')

rc = charout(arcFile, d2c(1), 208)
if rc <> 0 then do
   call LogCdi "Charout returned" rc "but 0 was expected"
end

rc = stream(arcFile, 'c', 'close')

address cmd '@attrib +r' arcFile

call lineout semFile, date() time()

call LogCdi "setting Archive for eCS systems."
cr = d2c(13)

message = 'Follow these instructions to create an archive once.' || cr ||,
          ' 1. Open the Desktop Properties.' || cr ||,
          ' 2. Select the Archives tab.' || cr ||,
          ' 3. Check the Archive Desktop checkbox.' || cr ||,
          ' 4. Check the at next Desktop startup only checkbox.' || cr ||,
          ' 5. Close the Desktop Properties.' || cr || cr ||,
          ' 6. Press OK to dismiss these instructions.'
call CDMessage message
call SysSleep 3

msgStatus = ''
rc = SysOpenObject('<WP_DESKTOP>', 'Settings', 1)
if rc <> 1 then do
   msgStatus = 'Quit'
   call LogCdi "Could not open desktop properties"
end

call CDMessageWait msgStatus

call LogCdi "The system has been set to Archive the Desktop at System boot"
return 0
