/* Present a Sequence to the user, and allow user edits
 * this program is called by the Display Monitor
 *
 * Arguments
 *   arg(1)    - the sequence name.
 *
 * Copyright (C) 2008 Blonde Guy
 * All Rights Reserved
 */

pipeName = '\pipe\suntan'
dialogName = 'Sequence Editor'
response = ''
cr = d2c(13)
sequence = arg(1)
instructions = "Currently editing" sequence || ". Single click each line to get a description of the item",
               "on that line. Double click or press enter to enable/disable",
               "the application on that line."


if stream(sequence, 'c', 'query exists') = '' then do
   call LogCdi "sequence not found:" sequence
   seqfile = query(dialogName, "sequence", "The sequence editor cannot find a",
        "sequence named" sequence || "." || cr || cr || "Specify the location",
        "of the sequence and press OK to continue.",,
        'File')
   if seqfile = '' then return
   else do
      @address cmd '@copy' seqfile '> nul'
      if rc <> 0 then do
         call LogCdi "Error" rc "copying" seqFile
         return
      end
   end
end

x = dialogName || d2c(10) || instructions || d2c(10) || "SeqEdCB.cmd"

do while lines(sequence)
   app = linein(sequence)
   x = x || d2c(10) || app
end
call stream sequence, 'c', 'close'

call LogCdi "!twopanel" x

call SysSleep 1

response = ''
notready = 0
do until response \= ''
   pipeState = stream(pipeName, 'c', 'open')
   if left(pipestate, 8) = 'NOTREADY' then do
      notready = notready + 1
      if notready > 9 then do
         response = 'dc='
      end
   end
   else do
      call lineout pipeName, "!dialogwait"
      response = linein(pipeName)
      notready = 0
   end
   call SysSleep 0.1
end

/* write back the sequence file */
seqdat = substr(response, 4)
if seqdat <> '' then do
   seqfile = sequence
   seqlen = 0
   call SysFileDelete seqfile
   do while seqdat <> ''
      parse var seqdat appname '#' seqdat
      seqlen = seqlen + length(appname)
      call lineout seqfile, appname
   end
   call lineout seqfile
end

return
