/* GamesFolder.cmd
 *
 * move game object into the Games Folder
 * arg is the game object
 * 
 * if arg is NULL, create the Games Folder used by Suntan Special
 *
 * Copyright (C) 2004 Blonde Guy
 * All Rights Reserved
 */

parse arg gameObject
gamesFolderName = cdglobal('gamesFolderName')
gamesFolderParent = cdglobal('gamesFolderParent')
gamesFolderID = cdglobal('gamesFolderID')

if gameObject \= '' then do
   rc = SysMoveObject(gameObject, gamesFolderID)
   if rc = 0 then do
      call CreateGamesFolder
      rc = SysMoveObject(gameObject, gamesFolderID)
      if rc = 0 then do
         call LogCdi "could not move" gameObject "to" gamesFolderName
      end
      /* close folder when done */
      address cmd '@sendmsg "' || gamesFolderName || '" WM_CLOSE'
   end
  return gamesFolderID
end

CreateGamesFolder:

rc = SysCreateObject('WPFolder', gamesFolderName, gamesFolderParent,,
                     'OBJECTID=' || gamesFolderID || ';OPEN=ICON',,
                     'UpdateIfExists')
if rc = 0 then do
   call LogCdi "Could not create" gamesFolderName "Folder"
end

return gamesFolderID
