/* FindBootDrive.cmd

   Determine drive letter where OS/2 is installed
   and return it in a string
*/

drive=strip(left(value('COMSPEC',,'OS2ENVIRONMENT'),1))

if drive \= '' then return drive

do while drive='' | stream(drive':\config.sys','c','query exists')=''

    say 'FindBootDrive is unable to automatically determine '
    say 'drive letter where OS/2 is installed'
    say

    /* unable to determine drive. Ask user */

    say 'Please enter drive letter for your OS/2 partition:'
    pull drive
    drive = left(drive,1)
    if stream(drive':\config.sys','c','query exists')=''
    then do
        say 'Invalid drive'
        drive=''
    end
end

return drive
