/* Copyright (c)1996 Kari Jackson for InnoVal Systems Solutions, Inc. */
/* To copy or move *.URL (bookmark) files to another WebWilly for OS/2 */
/* folder without overwriting existing files by the same names */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
signal on syntax name NoREXX
call SysLoadFuncs
signal on syntax name Syntax
signal on halt name Halt
'@ECHO OFF'
parse arg firstarg secondarg thirdarg .
if firstarg='' then do
   say ""
   say "Parameters:"
   say "-----------"
   say "1.  Source file specification:  If a directory name, the program will add"
   say "    *.URL to the end of it.  If not a directory, the program will add"
   say "    .URL to the end of it unless it already ends with .URL."
   say "2.  Target file specification:  A directory name.  If omitted, the files"
   say "    will be copied to the current directory.  Either way, the directory"
   say "    must be an existing WebWilly folder."
   say "3.  Add an /M switch to the end of the command if you want to move the"
   say "    files rather than copying them."
   exit
end
move=0
first.0=1
if length(firstarg)=3 & right(firstarg,2)=':\' then first.1=left(firstarg,2)
else call sysfiletree firstarg,'first','DO'
if firstarg\="*" & first.0>1 then do
   say ""
   do i=1 to first.0
      say first.i
   end
   say ""
   say "Parameter ("firstarg") not understood...."
   say "Multiple directories (above) by that name exist."
   exit
end
if firstarg\="*" & first.0=1 then source=first.1'\*.URL'
if firstarg="*" | first.0=0 then do
   if translate(right(firstarg,4))='.URL' then source=firstarg
   else source=firstarg'.URL'
end
select
   when translate(secondarg)='/M' then do
      move=1
      target=directory()
   end
   when secondarg='' then target=directory()
   otherwise do
      target=secondarg
      check.0=1
      if (length(target)=3 & right(target,2)=':\')|(length(target)=2 & right(target,1)=':') then check.1=target
      else call sysfiletree target,'check','DO'
      if check.0>1 then do
         say ""
         do i=1 to check.0
            say check.i
         end
         say ""
         say "Parameter ("target") not understood...."
         say "Multiple directories (above) by that name exist."
         exit
      end
      if check.0=0 then do
         say ""
         say "Directory ("target") does not exist.  Files"
         say "must be copied to an existing WebWilly folder."
         exit
      end
      if check.0=1 then target=check.1
   end
end
title=''
rc=SysGetEA(target,'WEBEXFOLDERNAME','title')
if rc>0 | strip(title)='' then do
   say ""
   say "Directory ("target") is not a WebWilly folder."
   exit
end
if translate(thirdarg)='/M' then move=1
call sysfiletree source,'files','FO'
if files.0=0 then do
   say ""
   say "No" source "file(s) found."
   exit
end
say ""
if right(target,1)='\' then target=substr(target,1,length(target)-1)
do i=1 to files.0
   lastslash=lastpos('\',files.i)+1
   parse var files.i . =(lastslash) filename
   if stream(target'\'filename,'c','query exists')<>'' then do
      parse var filename filename '.' .
      parse var filename five 6 six 7 seven 8 eight
      if length(eight)>1 then do
         say ""
         say "Filename ("filename") is longer than eight characters;"
         say "this is not valid for a *.URL file name.  Skipping this file...."
         say ""
         iterate
      end
      okay=0
      filename=translate(filename)
      characters='0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'
      origpos6=pos(six,characters)
      origpos7=pos(seven,characters)
      origpos8=pos(eight,characters)
      newpos6=origpos6
      newpos7=origpos7
      newchar6=six
      newchar7=seven
      do j=1 to 36 until okay=1
         do k=1 to 36 until okay=1
            do l=1 to 36 until okay=1
               newpos8=(origpos8+l)//36
               if newpos8=0 then newpos8=36
               newchar8=substr(characters,newpos8,1)
               filename=five||newchar6||newchar7||newchar8
               if stream(target'\'filename'.URL','c','query exists')='' then okay=1
            end
            newpos7=(origpos7+k)//36
            if newpos7=0 then newpos7=36
            newchar7=substr(characters,newpos7,1)
         end
         newpos6=(origpos6+j)//36
         if newpos6=0 then newpos6=36
         newchar6=substr(characters,newpos6,1)
      end
      if okay=0 then do
         say ""
         say "There are already 46,656 files in the" target
         say "directory with" five"???.URL filenames!"
         exit
      end
      filename=filename'.URL'
   end
   say files.i "-->" target'\'filename
   call sysfiledelete '$$temp$$.123'
   eautil files.i '$$temp$$.123 /s /p'
   if rc=0 then rc=lineout(target'\'filename)
   if rc=0 then eautil target'\'filename '$$temp$$.123 /j'
   if rc>0 then say '   WARNING:  UNSUCCESSFUL!'
   else if move=1 then call sysfiledelete files.i
   call sysfiledelete '$$temp$$.123'
end
exit
Syntax:
  say 'Error' rc 'in line' sigl':' errortext(rc)
  say sigl':' sourceline(sigl)
  exit
return
Halt:
   say 'CopyUrl.CMD interrupted by Ctrl-C, ShutDown, or closing of WorkArea.'
   exit
return
NoREXX:
   say 'Unable to load the REXXUtil functions.  Either the REXXUTIL.DLL file'
   say 'is not on the LIBPATH or REXX support is not installed on this system.'
   exit
return
