/* Copyright (c)1997 Kari Jackson for InnoVal Systems Solutions, Inc. */
/* To create Post Road Mailer-style *.POP files from a Hacksaw email file */
PROGNAME='MakePops.Cmd'
if RxFuncQuery('SysLoadFuncs') then call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
signal on syntax name NoREXX
call SysLoadFuncs
signal on syntax name Syntax
signal on halt name Halt
'@ECHO OFF'
parse arg firstarg secondarg thirdarg
if firstarg='' | pos('?',firstarg)>0 | thirdarg<>'' then do
   say ""
   say "Parameters:"
   say "-----------"
   say "1.  Source file specification:  Hacksaw's email output file."
   say ""
   say "2.  Target file specification:  The directory where you want the *.POP"
   say "    files created.  If omitted, the current directory will be assumed."
   exit
end
sourcefile=stream(firstarg,'c','query exists')
if sourcefile='' then do
   say ""
   say "Could not find" firstarg"."
   exit
end
select
   when secondarg='' then directory=directory()
   when length(secondarg)=3 & right(secondarg,2)=':\' then directory=secondarg
   otherwise do
      call sysfiletree secondarg,'dirnames.','DO'
      directory=dirnames.1
      if directory='DIRNAMES.1' then do
         say
         say secondarg "does not seem to be an existing directory."
         exit
      end
   end
end
testfile=getpopname(directory,'tmp')
if lineout(testfile) then do
   say
   say "Attempt to write to" directory "failed."
   exit
end
else call sysfiledelete testfile
do while lines(sourcefile)
   line=linein(sourcefile)
   select

/* the following line is for use with blamspam.cmd, and is incredibly
   unlikely to ever affect anything else, but can be removed or
   commented out without any effect on the rest of this program, if
   it's not to be used with blamspam.cmd */

      when left(line,38)="Message killed for presence of string:" then nop

/* the following line is for Hacksaw's default separator line */
/* comment it out if you uncomment the subsequent line for a Unix-style file */

      when left(line,13)="-=-=-=-=-=-= " & pos(" Message [",line)>27 & right(line,14)="] =-=-=-=-=-=-" then do

/* the following line is for a Unix-style separator line */
/* uncomment it and comment the one above, if you use that separator */
/* instead of Hacksaw's default one */

/*    when left(line,5)="From " then do */

         if outfile<>'OUTFILE' then call lineout outfile
         outfile=getpopname(directory,'pop')
      end
      otherwise call lineout outfile,line
   end
end
exit
Syntax:
  say 'Error' rc 'in line' sigl':' errortext(rc)
  say sigl':' sourceline(sigl)
  exit
return
Halt:
   say ProgName 'interrupted by Ctrl-C, ShutDown, or closing of WorkArea.'
   exit
return
NoREXX:
   say 'Unable to load the REXXUtil functions.  Either the REXXUTIL.DLL file'
   say 'is not on the LIBPATH or REXX support is not installed on this system.'
   exit
return
/* Copyright (c)1996,1997 Kari Jackson for InnoVal Systems Solutions, Inc. */
/* Subroutine to produce a *.POP-style filename */
/* Returns d:\dirname\filename.ext or "error" */
GetPopName:procedure
parse arg directory,extension
if right(directory,1)='\' then directory=substr(directory,1,length(directory)-1)
if left(extension,1)='.' then extension=substr(extension,2)
characters='0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'
parse value date("O") with . 2 year "/" month "/" day
parse value time() with hour ":" minute ":" second
month=substr(characters,month+1,1)
day=substr(characters,day+1,1)
hour=substr(characters,hour+1,1)
fifth=minute%36
sixth=substr(characters,minute//36+1,1)
test=second//36
string=year||month||day||hour||fifth||sixth
do j=1 to 36
   test2=(test+j)//36
   if test2=0 then seventh=substr(characters,36,1)
   else seventh=substr(characters,test2,1)
   do i=1 to 36
      tryit=string||seventh||substr(characters,i,1)
      filename=directory||"\"||tryit||'.'||extension
      if stream(filename,'c','query exists')='' then return filename
   end
end
/* there have already been 1296 files created in that directory this minute */
return 'error'
