/* REXX file to install the DH-Grep-PM on the desktop     */
/* if you use this script as a starting point for your   */
/* own install script and make improvements, please send */
/* me a copy ---  dwhawk@southwind.net                   */

call rxfuncadd 'sysloadfuncs', 'rexxutil', 'sysloadfuncs'
call sysloadfuncs                /* register system functions */
address cmd '@echo off'          /* echo is turned off */

call SysCLS

say "RacerNet installation"
say "Enter destination drive and directory"
say "For example, C:\RACERNET"
say "Hint:  If you already have NetLookout installed, install RacerNet in the same directory, so you won't have two copies of the DLL files."
say "To install in the curent directory just press enter"

pull dest
call setup_dir(dest) 
call copy_files
call MKOBJ
say "**************************************"
say "**************************************"
say " "
say "You must add the line"
say " "
say " SET USE_HOSTS_FIRST=1"
say " "
say "to your config.sys file"
say "for RacerNet to work correctly."
say " "
say "After adding this to your config.sys file, you must re-boot."
say " "
say "**************************************"
say "**************************************"
exit

check_ok:
  say  'Okay to continue(Y/n) ? '        
  k = SysGetKey('NOECHO') 
  if k = 'Y' | k = 'y'  then return
  say 'halting'
    exit


mkdir:  /* Procedure for creating dir */
  Parse Arg dir
  rc = SysMkDir(dir)
  If (rc = 0 | rc = 5) Then Return
  Say 'Problem creating destination directory "'dir'"'
  Exit


MKOBJ:
Settings = 'EXENAME='direct||'\rcneto.exe;'
Settings = Settings||'PROGTYPE=PM;MINIMIZED=NO;'
Settings = Settings||'CCVIEW=YES;'
Settings = Settings||'STARTUPDIR='||direct';'
rc=SysCreateObject('WPProgram','RacerNet','<WP_DESKTOP>',Settings,'R');

if rc = 1 then Say "RacerNet installed on desktop"
return

setup_dir:      /* accept install path and create it if needed */
                /* the desired install path is in ARG(1) */
                /* if no path is specified current directory is used*/

Parse Arg destin  /* parameter of setup_dir */

save_dest = destin    /*  save original destin to */
                      /*  determine if copy needed */

If destin = "" Then destin = Directory()

Say "Shall I install in "destin" ?"
Call Check_Ok  /* your check routine */

Parse Var destin direct ':\' destin   /* get drive name only */
direct=direct':'

Do Until destin = ""     /* No matter how many sub dirs present */
  Parse Var destin sub '\' destin
  direct=direct'\'sub
  Call mkdir direct
End
return

copy_files:
if save_dest \= ""  then do
   'COPY rcneto.exe' direct
   'COPY frugrsrc.dll' direct
   'COPY frugm30.dll' direct
   'COPY frugob3.dll' direct
   'COPY frugou3.dll' direct
   'COPY readme.txt' direct
   'COPY register.txt' direct
   'COPY help.htm' direct
   'COPY rnet0.gif' direct
   'COPY rnet5.gif' direct
   'COPY rnet8.gif' direct
   'COPY rnet3.gif' direct
   'COPY rnet4.gif' direct
   'COPY rnet9.gif' direct

end
return

