/* REXX installation script for LanScan */

  Call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
  Call SysLoadFuncs
  Call SysCls

  say "Create LanScan object on desktop? Y/N"
  say " ꥪ LanScan  ⮯? /"
  pull Ans
  if \ ( (Ans="Y") | (Ans="y") | (Ans="") | (Ans="") ) then exit

  FolderId = '<LanScan_Folder>'
  setup = 'OBJECTID='FolderId';ICONFILE='||Directory()||,
          '\LanScan1.ico;ICONNFILE=1,'||Directory()||'\LanScan2.ico'
  rc = SysCreateObject('WPFolder', 'LanScan', '<WP_DESKTOP>', setup, 'R')
  if rc = 0 then do
    say 'LanScan folder object did not created'
    say '訡  ᮧ  LanScan'
    exit
  end

  say ""
  say "Create LanScan program object? Y/N"
  say " ணࠬ ꥪ LanScan? /"
  pull Ans
  if \ ( (Ans="Y") | (Ans="y") | (Ans="") | (Ans="") ) then signal CrtDaemon

  PgmName = 'LanScan'
  PgmTitle = 'LanScan'
  PgmSetup = 'OBJECTID=<'PgmName'>;'||'EXENAME='||Directory()||,
           '\'PgmName'.exe;'||'STARTUPDIR='||Directory()';'||'PROGTYPE=PM'
  rc = SysCreateObject("WPProgram", PgmTitle, FolderId, PgmSetup, 'R')
  if rc = 0 then do
    say 'Program object <'PgmTitle'> did not created'
    say '訡  ᮧ ணࠬ ꥪ <'PgmTitle'>'
    exit
  end

CrtDaemon:
  say ""
  say "Create LanScan Daemon (VIO) program object? Y/N"
  say " ணࠬ ꥪ LanScan  (VIO)? /"
  pull Ans
  if \ ( (Ans="Y") | (Ans="y") | (Ans="") | (Ans="") ) then signal CrtView

  PgmName = 'LanScanD'
  PgmTitle = 'LanScan Daemon'
  PgmSetup = 'OBJECTID=<'PgmName'>;'||'EXENAME='||Directory()||,
           '\'PgmName'.exe;'||'STARTUPDIR='||Directory()||,
           ';PROGTYPE=WINDOWABLEVIO'
  rc = SysCreateObject("WPProgram", PgmTitle, FolderId, PgmSetup, 'R')
  if rc = 0 then do
    say 'Program object <'PgmTitle'> did not created'
    say '訡  ᮧ ணࠬ ꥪ <'PgmTitle'>'
    exit
  end

CrtView:
  say ""
  say "Create LanScan View program object? Y/N"
  say " ணࠬ ꥪ LanScan View? /"
  pull Ans
  if \ ( (Ans="Y") | (Ans="y") | (Ans="") | (Ans="") ) then signal CrtCfg

  say ""
  say "Enter LanScan server IP address"
  say " IP  ࢥ LanScan"
  pull ipaddr
  say "Enter LanScanV service port number"
  say "   ࢨ LanScanV"
  pull port

  PgmName = 'ViewLS'
  PgmTitle = 'LanScan View'
  PgmSetup = 'OBJECTID=<'PgmName'>;'||'EXENAME='||Directory()||,
           '\'PgmName'.exe;'||'STARTUPDIR='||Directory()';'||'PROGTYPE=PM;'||,
           'PARAMETERS='ipaddr' 'port
  rc = SysCreateObject("WPProgram", PgmTitle, FolderId, PgmSetup, 'R')
  if rc = 0 then do
    say 'Program object <'PgmTitle'> did not created'
    say '訡  ᮧ ணࠬ ꥪ <'PgmTitle'>'
    exit
  end

CrtCfg:
  say ""
  say "Create LanScan Configure program object? Y/N"
  say " ணࠬ ꥪ LanScan Configure? /"
  pull Ans
  if \ ( (Ans="Y") | (Ans="y") | (Ans="") | (Ans="") ) then signal CrtInf

  say ""
  say "Enter LanScan server IP address"
  say " IP  ࢥ LanScan"
  pull ipaddr
  say "Enter LanScanC service port number"
  say "   ࢨ LanScanC"
  pull port

  PgmName = 'CfgLanS'
  PgmTitle = 'LanScan Configure'
  PgmSetup = 'OBJECTID=<'PgmName'>;'||'EXENAME='||Directory()||,
           '\'PgmName'.exe;'||'STARTUPDIR='||Directory()';'||'PROGTYPE=PM;'||,
           'PARAMETERS='ipaddr' 'port
  rc = SysCreateObject("WPProgram", PgmTitle, FolderId, PgmSetup, 'R')
  if rc = 0 then do
    say 'Program object <'PgmTitle'> did not created'
    say '訡  ᮧ ணࠬ ꥪ <'PgmTitle'>'
    exit
  end

CrtInf:
  ObjSetup = 'OBJECTID=<LanScan Info>;'||'SHADOWID='||Directory()||,
           '\LanScan.INF'
  rc = SysCreateObject("WPShadow", 'LanScan Info', FolderId, ObjSetup, 'R')
  if rc = 0 then do
    say 'Object <LanScan Info> did not created'
    say '訡  ᮧ ꥪ <LanScan Info>'
    exit
  end

  say ""
  say "Successful creation of object LanScan"
  say "ᯥ譮 ᮧ ꥪ LanScan"