#include <stdlib.h>
#include <stdio.h>
#include <dnpap.h>
#include <snmp.h> 
#include <mibdf.h>
#include <config.h>
#include "exec.h"
#include "parse.h"


int main(int argc, char **argv)
{
	SNMP_OBJECT list[1];
	unsigned listLen;
	int ret;      
	char answer[256];	       
	
	if(argc != 2)
	{
		DnpapMessage(DMC_ERROR,TRICKLET_ERROR,"Call as:  snmp-info <MIB-var name>\n");
		DnpapExit(2);
	}
	
	if (ConfigInit(argc, argv) == FALSE || ConfigLoad() == FALSE)
	{
		DnpapMessage(DMC_ERROR, TRICKLET_ERROR, "ConfigInit failed\n");
		DnpapExit(1);
	}

	if (MibInit() != 0 || MibFullMib() != 0)
	{
		DnpapMessage(DMC_ERROR, TRICKLET_ERROR, "MibInit failed\n");
		DnpapExit(1);
	}

    if(GetList(argv[1], list, 1, &listLen)<0)
	{
		sprintf(answer,"Couldn't parse <%s>",argv[1]);
		return 0;
	}
	ret = MibIDInfo(list[0].Id,list[0].IdLen-1,answer);
	if (ret != 0)
	{
		puts("couldn't get info");
	}
	puts(answer);
	return 0;
}




