include ../../include/gcc_os2.std

SYS     = tricklet
SYSLIB  = tricklet

all: snmp-get snmp-nxt snmp-set snmp-tbl snmp-info spook

snmp-get: get.o parse.o exec.o
	$(LN) $(CFLAGS) -o snmp-get get.o exec.o parse.o $(LDFLAGS)  -lmibdf -lmgmt -lsnmp -ldnpap -los2
	emxbind -bs snmp-get
			  
snmp-nxt: next.o parse.o exec.o
	$(LN) $(CFLAGS) -o snmp-nxt next.o exec.o parse.o $(LDFLAGS)  -lmibdf -lmgmt -lsnmp -ldnpap -los2
	emxbind -bs snmp-nxt
			  
snmp-set: set.o parse.o exec.o
	$(LN) $(CFLAGS) -o snmp-set set.o exec.o parse.o $(LDFLAGS)  -lmibdf -lmgmt -lsnmp -ldnpap -los2
	emxbind -bs snmp-set
			  
snmp-tbl: table.o parse.o exec.o
	$(LN) $(CFLAGS) -o snmp-tbl table.o exec.o parse.o $(LDFLAGS)  -lmibdf -lmgmt -lsnmp -ldnpap -los2
	emxbind -bs snmp-tbl

snmp-info: info.o parse.o
	$(LN) $(CFLAGS) -o snmp-info info.o parse.o $(LDFLAGS)  -lmibdf -lmgmt -lsnmp -ldnpap -los2
	emxbind -bs snmp-info

spook: spook.o parse.o
	$(LN) $(CFLAGS) -o spook spook.o parse.o $(LDFLAGS)  -lmibdf -lmgmt -lsnmp -ldnpap -los2
	emxbind -bs spook

clean:
	- $(RM) *.o
	- $(RM) *.a
	- $(RM) *.exe
	- $(RM) core
	- $(RM) snmp-get
	- $(RM) snmp-nxt
	- $(RM) snmp-set
	- $(RM) snmp-tbl
	- $(RM) snmp-info
	- $(RM) spook
	- $(RM) *.man
	- $(RM) *.err
	- $(RM) *.bak

install: $(BINDIR)/snmp-get.exe $(BINDIR)/snmp-nxt.exe $(BINDIR)/snmp-set.exe $(BINDIR)/snmp-tbl.exe $(BINDIR)/snmp-info $(BINDIR)/spook.exe

$(BINDIR)/snmp-get.exe: snmp-get.exe
	$(CP) snmp-get.exe $(BINDIR)/snmp-get.exe

$(BINDIR)/snmp-nxt.exe: snmp-nxt.exe
	$(CP) snmp-nxt.exe $(BINDIR)/snmp-nxt.exe

$(BINDIR)/snmp-set.exe: snmp-set.exe
	$(CP) snmp-set.exe $(BINDIR)/snmp-set.exe

$(BINDIR)/snmp-tbl.exe: snmp-tbl.exe
	$(CP) snmp-tbl.exe $(BINDIR)/snmp-tbl.exe
        
$(BINDIR)/snmp-info.exe: snmp-info.exe
	$(CP) snmp-info.exe $(BINDIR)/snmp-info.exe
        
$(BINDIR)/spook.exe: spook.exe
	$(CP) spook.exe $(BINDIR)/spook.exe
        

get.o: get.c npsnmp.h exec.h parse.h

next.o: next.c npsnmp.h exec.h parse.h

set.o: set.c npsnmp.h exec.h parse.h

info.o: info.c

table.o: table.c npsnmp.h exec.h parse.h

spook.o: spook.c npsnmp.h parse.h

parse.o: parse.c parse.h


exec.o: exec.c exec.h 
