/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       exec.c
**     SYSTEM   NAME:       tricklet
**     ORIGINAL AUTHOR(S):  Jan van Oorschot
**     VERSION  NUMBER:     
**     CREATION DATE:       
**
** DESCRIPTION: 
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION: $Revision$
** AUTHOR:   $Author$
** DATE:     $Date$
** LOG:      $Log$
*************************************************************************/
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <dnpap.h>
#include <snmp.h>
#include <mibdf.h>
#include <stdarg.h>
#include <dnpap.h>
#include <mgmt.h>
#include <config.h>
#include "exec.h"
#include "parse.h"



char *SNMP_Errors[]=
{
    "No Error",		                   			        /* PKT_NOERROR */
    "Too big, too many SNMP variables in one request",	/* PKT_TOOBIG */
    "No such MIB variable name",		                /* PKT_NOSUCHNAME */
    "Bad value",				                        /* PKT_BADVALUE */
    "Attempt to write READONLY MIB variable",	        /* PKT_READONLY */
    "General SNMP error"			                    /* PKT_GENERR */
};


int snmp_exec(int argc, char *argv[], int type)
{
	BYTE            *agent;
	BYTE            *comm;
    WORD            commLen;
	INT             medium;
    ULONG           timeout;
	USHORT          retries;
	MGMT            *handle;
    SNMP_OBJECT     list[LIST_SIZE];
    INT             listLen;
    WORD            status, index;
	CHAR            line[2048];
	INT             table[2048];
	INT             tableLen;
	INT             r;
    WORD            tag;
	INT             rc;

	
	if (argc>=2)
        agent=argv[1];
    else
        agent=0;
	
	if(argc>=3)
    {
        comm=argv[2];
        commLen=strlen(comm);
    }
    else
    {
        comm=0;
        commLen=0;
    }
    if (argc>=4)
    {
        if (argv[3][0]=='U' || argv[3][0]=='u')
            medium=MGMT_TYPE_UDP;
        else if (argv[3][0]=='P' || argv[3][0]=='p')
            medium=MGMT_TYPE_PIPE;
        else
            medium=MGMT_TYPE_DEFAULT;
    }
    else
    {
        medium=MGMT_TYPE_DEFAULT;
    }
	if(argc>=5)
		timeout=atol(argv[4]);
    else
	    timeout=0;
	if(argc>=6)
		retries=atoi(argv[5]);
    else
	    retries=0;

    if (ConfigInit(argc, argv) == FALSE || ConfigLoad() == FALSE)
    {
        DnpapMessage(DMC_ERROR, TRICKLET_ERROR, "ConfigInit failed\n");
        DnpapExit(1);
    }

	if (MgmtInit() == FALSE)
	{
	    DnpapMessage(DMC_ERROR,TRICKLET_ERROR,"MgmtInit failed\n");
        DnpapExit(1);
	}

	if (MibInit()!=0 || MibFullMib()!=0)
	{
	    DnpapMessage(DMC_ERROR,TRICKLET_ERROR,"MibInit failed\n");
        DnpapExit(1);
	}


    handle = MgmtOpen(agent, medium);
	if(handle == NULL)
    {
	    DnpapMessage(DMC_ERROR, TRICKLET_ERROR,"Opening SNMP to %s failed\n",
                agent);
        DnpapExit(1);
    }	

		   
    
	while(gets(line))
	{
        rc=GetList(line, list, LIST_SIZE, &listLen);
        if (rc<0)
    	{
            if (rc==-1)
    	        DnpapMessage(
                        DMC_ERROR,
                        TRICKLET_ERROR,
            		    "Couldn't parse <%s>\n",
		                line
            		    );
            else
            if (rc==-2)
    	        DnpapMessage(
                        DMC_ERROR,
                        TRICKLET_ERROR,
            		    "Too many variables in request <%s>\n",
		                line
            		    );
    		MgmtClose(handle);
	    	return -1;
    	}
	tableLen=list[0].IdLen;
	memcpy(table,list[0].Id,tableLen*sizeof(list[0].Id[0]));
	while(1)
	{
	    if (type == SNMP_PDU_TABEL)
               tag = SNMP_PDU_NEXT;
           else
               tag = type;
	    if(!MgmtRequest(handle,comm,commLen,tag,list,listLen,&status,&index,timeout,retries))
	    {
            DnpapMessage(
                DMC_ERROR,
	            TRICKLET_ERROR,
			    "SNMP request failed, to many retries\n"
			    );
           break;
	    }
	    if(type == SNMP_PDU_TABEL)
	      if (memcmp(table, list[0].Id,tableLen*sizeof(list[0].Id[0]))!=0 ||
			status == SNMP_NOSUCHNAME)
			break;

	    if (status!=SNMP_NOERROR)
	    {
		    r=PutIdentifier(list+index-1,line,sizeof(line));
               if (r<0)
			    line[0]='\0';
		    else
			    line[r]='\0';
            DnpapMessage(
                   DMC_ERROR,
	            TRICKLET_ERROR,
			    "SNMP error: <%s>, variable %d, %s\n",
			    SNMP_Errors[status], index,
			    line
			    );
	    }
           else
           {
	        r=PutList(list, listLen, line,sizeof(line));
               if (r<0)
               {
                DnpapMessage(
                   DMC_ERROR,
	            TRICKLET_ERROR,
			    "Couldn't handle result list\n"
			    );
               }
		    else
               {
			    line[r]='\0';
	            puts(line);
               }
           }
	    if(type != SNMP_PDU_TABEL)
	      break;
	}
	if(type == SNMP_PDU_TABEL)
		break;
	}
	MgmtClose(handle);
	return 0;
}

