/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       protparm.h
**     SYSTEM   NAME:       NDIS\PROTPARM
**     ORIGINAL AUTHOR(S):  Paul Lemmers
**     VERSION  NUMBER:     
**     CREATION DATE:       1990/8/31
**
** DESCRIPTION: 
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.1  $
** WORKFILE:    $Workfile:   protparm.h  $
** LOGINFO:     $Log:   D:/CPROG/NDIS/PROTPARM/VCS/PROTPARM.H_V  $
**              
**                 Rev 1.1   09 Dec 1990 19:55:36   PAUL
**              Adaptions for MSC 6.00
**              
**                 Rev 1.0   03 Sep 1990 13:43:00   PAUL
**              Initial revision.
*************************************************************************/

/* Protocol.ini parameter parsing descriptor. */
typedef struct _parmd {
	unsigned char  type;     /* 0 == int; 1 == string */
	unsigned char  nparms;   /* # of parms with keyword */
	unsigned short parmsize; /* # of bytes in single dest entry */
	                         /* 0 if no parm storing needed */
	char	*keyw;           /* ptr to keyword */
	long	min;             /* Minimal value for parm */
	long	max;             /* Maximal value for parm */
	void	*binp;           /* Destination pointer */
	int	(*funcp)(KEYW_E _far *, struct _parmd *);
	                         /* Parse function pointer */
	                         /* NULL if default parsing */
	} PARMD;
	


int	DoSection(MOD_E _far *ModP, PARMD *myparms, unsigned short cnt);
int	IsMySection(MOD_E _far *ModP, char *devname);
PARMD	*IsValidKeyword(KEYW_E _far *keywp, PARMD *parmp, unsigned short cnt);
int	DoKeyword(KEYW_E _far *keywp, PARMD *parmp);
