include ../../include/gcc_os2.std

SYS     = message
SYSLIB  = dnpap

OBJ = msgfile.o msgmain.o msgtrans.o msgvio.o

all: obj doc

install: all $(INCDIR)/$(SYS).h $(MANDIR)/$(SYS).man $(LIBDIR)/lib$(SYSLIB).a 

$(INCDIR)/$(SYS).h: $(SYS).h 
	$(CP) $(SYS).h $(INCDIR)/$(SYS).h

$(MANDIR)/$(SYS).man: $(SYS).man 
	$(CP) $(SYS).man $(MANDIR)/$(SYS).man 

$(LIBDIR)/lib$(SYSLIB).a: $(OBJ) 
	$(AR) $(LIBDIR)/lib$(SYSLIB).a $(OBJ) 

obj: $(OBJ)
       
doc: $(SYS).man

clean:
	- $(RM) *.o
	- $(RM) *.a
	- $(RM) *.exe
	- $(RM) core
	- $(RM) test
	- $(RM) *.man
	- $(RM) *.err
	- $(RM) *.bak

$(SYS).man: msgfile.c msgmain.c msgtrans.c msgvio.c 
	$(MAN) msgfile.c msgmain.c msgtrans.c msgvio.c > $(SYS).man

msgfile.o: msgfile.c $(SYS).h

msgmain.o: msgmain.c $(SYS).h

msgtran.o: msgtrans.c $(SYS).h

msgvio.o: msgvio.c $(SYS).h


test.exe: test
	emxbind -bs test

test: test.o $(INC)
	$(LN) $(CFLAGS) -o test test.o $(OBJ) $(LDFLAGS) -ldnpap -os2
