include ../../include/gcc_unx.std

SYS     = config
SYSLIB  = dnpap

OBJ = high.o low.o value.o

all: obj doc

install: all $(INCDIR)/$(SYS).h $(MANDIR)/$(SYS).man $(LIBDIR)/lib$(SYSLIB).a 

$(INCDIR)/$(SYS).h: $(SYS).h 
	$(CP) $(SYS).h $(INCDIR)/$(SYS).h

$(MANDIR)/$(SYS).man: $(SYS).man 
	$(CP) $(SYS).man $(MANDIR)/$(SYS).man 

$(LIBDIR)/lib$(SYSLIB).a: $(OBJ) 
	$(AR) $(LIBDIR)/lib$(SYSLIB).a $(OBJ) 
	ranlib $(LIBDIR)/lib$(SYSLIB).a
	
obj: $(OBJ)
       
doc: $(SYS).man

clean:
	- $(RM) *.o
	- $(RM) *.a
	- $(RM) *.exe
	- $(RM) core
	- $(RM) test
	- $(RM) *.man
	- $(RM) *.err
	- $(RM) *.bak

$(SYS).man: high.c low.c value.c
	$(MAN) high.c low.c value.c > $(SYS).man

high.o: high.c $(SYS).h

low.o: low.c $(SYS).h

value.o: value.c $(SYS).h

test.exe: test
	emxbind -bs test

test: test.o $(OBJ)
	$(LN) $(CFLAGS) -o test test.o $(OBJ) $(LDFLAGS) -ldnpap
