#define  INCL_BASE
#include <os2.h>
#include <memory.h>
#include <stdio.h>
#include <maxmem.h>
#include <dnpap.h>
#include <message.h>
#include <timer.h>
#include <block.h>
#include <mac.h>
#include <snor.h>
#include <agent.h>
#include <ether.h>
#include <ip.h>
#include <icmp.h>
#include <udp.h>
#include <pipe.h>
#include <echo.h>
#include <snmp.h>
#include <mibsup.h>
#include <sys.h>
#include <maxmib.h>
#include <agent.h>
#include <info.h>
#include <stat.h>
#include <hist.h>
#include <protocol.h>
#include <capture.h>
#include <filter.h>
#include <channel.h>
#include <matrix.h>
#include <host.h>
#include <topn.h>
#include <alarm.h>
#include <event.h>
#include <config.h>
#include <soft.h>
#include <loop.h>
#include <gen.h>

#ifdef DNPAP_RMON_EXTENSIONS
#include <dstats.h>
#include <dfilter.h>
#include <dhost.h>
#include <dtopn.h>
#include <dmatrix.h>
#endif




static VOID BeholderSignalHandler(INT signum);



INT main(INT argc, char **argv)
{
    ULONG start,now,count;
    
    
    if (ConfigInit(argc, argv) == FALSE || ConfigLoad() == FALSE)
    {
        DnpapMessage(DMC_FATAL, 5, "ConfigInit failed");
        DnpapExit(1);
    }

    MemoryInit(8000000L, 32000L);

    if (DnpapSignal(SIGINT, BeholderSignalHandler) == SIG_ERR)
        DnpapMessage(DMC_FATAL, 6, "Signal handler initialization failed");
    
    MessageInit("stdio:out", MSGFILE, MSGSTDIO, NULL);
    MessageConfig(BEHOLDER_ERROR, "Beholder");
    
    if (!TimerInit())
        DnpapMessage(DMC_WARNING,1,"TimerInit failed");
    
    if (!BlockInit())
        DnpapMessage(DMC_WARNING,2,"BlockInit failed");

    if (!SnorInit())
        DnpapMessage(DMC_WARNING,3,"SnorInit failed");

    if (!MacInit())
        DnpapMessage(DMC_WARNING,4,"MacInit failed");
    
    start = now = SnorTime();
    count = 0L;
    while (now-start < 60000000L)
    {
        count++;
        now = SnorTime();
    }
    printf("%lu %lu %lu\n", count, now-start, (now-start)/count);

    DnpapExit(0);

    return 0;
}


VOID BeholderSignalHandler(INT signum)
{
    DnpapExit(0);
}
