#include <stdarg.h>
#include <stdio.h>
#include "snordef.h"
#include "snorerr.h"

typedef struct _SNOR_ERR_ELEM  SNOR_ERR_ELEM;

struct _SNOR_ERR_ELEM
{
	USHORT	code;
	char	*text;
};

#define ELEM_SIZE(p) (sizeof(p)/sizeof(*p)),p
static char *LinSearch(USHORT code, USHORT size, SNOR_ERR_ELEM *tab);

void SnorErrPrint(BYTE *format, ...)
{
	static char buffer[80];
    va_list  parg;

    va_start(parg, format);
	vsprintf(buffer, format, parg);
    DnpapMessage(DMC_ERROR,SNOR_ERROR,buffer);
}





char *SnorErrEvent(USHORT event)
{
static SNOR_ERR_ELEM SnorErrEvents[] = {
	{EVENT_GET_CONFIG, "EVENT_GET_CONFIG"},
	{EVENT_MAX_LEN, "EVENT_MAX_LEN"},
	{EVENT_TYPE_LEN, "EVENT_TYPE_LEN"},
	{EVENT_GENREQ, "EVENT_GENREQ"},
	{EVENT_SEND, "EVENT_SEND"},
	{EVENT_STATUS, "EVENT_STATUS"},
	{EVENT_FRAME, "EVENT_FRAME"},
	{EVENT_LOST_FRAMES, "EVENT_LOST_FRAMES"},
	{EVENT_DUMMY, "EVENT_DUMMY"},
	{0, "Unknown event"}
	};

	return( LinSearch(event, ELEM_SIZE(SnorErrEvents)) );
}

char *SnorErrFunction(USHORT function)
{
static SNOR_ERR_ELEM SnorErrFunctions[] = {
	{ NEUS_MOTOR, "NEUS_MOTOR"},
	{ NEUS_GIVE, "NEUS_GIVE"},
	{ NEUS_GET_CONFIG, "NEUS_GET_CONFIG"},
	{ NEUS_MAX_LEN, "NEUS_MAX_LEN"},
	{ NEUS_TYPE_LEN, "NEUS_TYPE_LEN"},
	{ NEUS_GENREQ, "NEUS_GENREQ"},
	{ NEUS_SEND, "NEUS_SEND"},
	{0, "Unknown NEUS Function code"}
	};

	return( LinSearch(function, ELEM_SIZE(SnorErrFunctions)) );
}

char *SnorErrError(USHORT error)
{
static SNOR_ERR_ELEM SnorErrErrors[] = {
	{NER_NO_GIVE, "NER_NO_GIVE"},
	{NER_TOO_MANY, "NER_TOO_MANY"},
	{NER_INVALID_PARM, "NER_INVALID_PARM"},
	{NER_INVALID_TXSEG, "NER_INVALID_TXSEG"},
	{NER_INVALID_RXSEG, "NER_INVALID_RXSEG"},
	{NER_TOO_MANY_RXSEG, "NER_TOO_MANY_RXSEG"},
	{NER_DUP_GIVE, "NER_DUP_GIVE"},
	{NER_INVALID_SEG, "NER_INVALID_SEG"},
	{NER_OUT_OF_MEM, "NER_OUT_OF_MEM"},
	{NER_NOT_BOUND, "NER_NOT_BOUND"},
	{0, "Unknown error"}
	};

	return( LinSearch(error&0xff, ELEM_SIZE(SnorErrErrors)) );
}

static char *LinSearch(USHORT code, USHORT size, SNOR_ERR_ELEM *tab)
{
	tab[size-1].code = code;

	while ( tab->code != code )
		tab++;

	return(tab->text);
}



