!include ..\..\..\include\standard.mak

SYS     = snor
SYSLIB  = stack
OBJS    = $(SYS).obj $(SYS)dev.obj $(SYS)kel.obj $(SYS)seg.obj $(SYS)sub.obj $(SYS)rqs.obj $(SYS)err.obj $(SYS)evt.obj $(SYS)hdl.obj $(SYS)sem.obj
LIBS    = $(LIBDIR)\dnpap.lib $(LIBDIR)\b2.lib $(LIBDIR)\stack.lib $(LIBDIR)\collect.lib $(LIBDIR)\system.lib $(LIBDIR)\snmp.lib $(LIBDIR)\dnpapx.lib 

all: obj doc

install: all $(INCDIR)\$(SYS).h $(MANDIR)\$(SYS).man $(LIBDIR)\$(SYSLIB).lib

$(INCDIR)\$(SYS).h: $(SYS).h 
	$(CP) $(SYS).h $(INCDIR)\$(SYS).h

$(MANDIR)\$(SYS).man: $(SYS).man 
	$(CP) $(SYS).man $(MANDIR)\$(SYS).man 

$(LIBDIR)\$(SYSLIB).lib: $(OBJS)
        $(AR) $(LIBDIR)\$(SYSLIB).lib -+$(SYS).obj -+$(SYS)dev.obj -+$(SYS)kel.obj -+$(SYS)seg.obj -+$(SYS)sub.obj -+$(SYS)rqs.obj -+$(SYS)err.obj -+$(SYS)evt.obj -+$(SYS)hdl.obj -+$(SYS)sem.obj;

obj: $(OBJS)

doc: $(SYS).man

clean:
    - $(RM) *.exe
    - $(RM) *.obj
    - $(RM) *.i
    - $(RM) *.lib
    - $(RM) *.man
    - $(RM) *.err
    - $(RM) *.bak

$(SYS).man: $(SYS).c
    $(MAN) -R:API  $(SYS).c > $(SYS).man

$(SYS).obj: $(SYS).c $(SYS).h

test.exe: test.obj  $(LIBS)
    $(LINK) test.obj  $(LIBS)
    markexe windowcompat test.exe
