#include <stdio.h>
#include <string.h>
#include <mac.h>
#include <config.h>
#include "loop.h"

#define LOOP_MTU    4096    


static BOOLEAN Send(MAC_IFACE *iface, CHAIN *chain);
static BOOLEAN Stat(MAC_IFACE *iface, MAC_STAT *stat);


BOOLEAN LoopInit(void)
{
    BYTE            name[255];
    BYTE            *descr;
    MAC_IFACE       *loop;
    WORD            i;
    static BOOLEAN  init = FALSE;
    
    if (!init)
    {
        i = 1;
        sprintf(name, "loop.iface.name.%d", i);
        while (ConfigGetString(name, &descr))
        {
            loop = DnpapMalloc(sizeof(MAC_IFACE));
            if (loop!=0)
            {
                strcpy(loop->descr, descr);
                loop->Send          = Send;
                loop->Stat          = Stat;
                loop->type          = MAC_TYPE_SOFT_LOOPBACK;
                loop->speed         = 0;
                loop->mtu           = LOOP_MTU;
                loop->statusOper    = TRUE;
                loop->statusAdmin   = TRUE;
                loop->arp           = MAC_ARP_NONE;
                loop->addrLength    = 0;
                MacIfaceRegister(loop);
            }
            
            i++;
            sprintf(name, "loop.iface.name.%d", i);
        }

        init = TRUE;
    }

    return init;
}


static BOOLEAN Send(MAC_IFACE *iface, CHAIN *chain)
{
    CHAIN       *new;
    MAC_INFO    info;
    WORD        length;

    
    length = ChainLength(chain);
    new = ChainAlloc(0, 0, length, length, 0, 0);
    if (new)
    {
        if (ChainCopy(chain, new->buffer, length))
        {   
            info.length      = length;
            info.copied      = length;
            info.time        = 0L;
            info.promiscuous = FALSE;
            return MacRcve(iface, new, &info);
        }
    }
    return FALSE;
}


static BOOLEAN Stat(MAC_IFACE *iface, MAC_STAT *stat)
{
    return TRUE;
}
