!include ..\..\..\include\standard.mak

SYS     = ip
SYSLIB  = stack

all: obj doc

install: all $(INCDIR)\$(SYS).h $(MANDIR)\$(SYS).man $(LIBDIR)\$(SYSLIB).lib

$(INCDIR)\$(SYS).h: $(SYS).h 
	$(CP) $(SYS).h $(INCDIR)\$(SYS).h

$(MANDIR)\$(SYS).man: $(SYS).man 
	$(CP) $(SYS).man $(MANDIR)\$(SYS).man 

$(LIBDIR)\$(SYSLIB).lib: $(SYS).obj $(SYS)send.obj $(SYS)rcve.obj $(SYS)route.obj $(SYS)iface.obj $(SYS)prot.obj $(SYS)hdr.obj $(SYS)reas.obj
        $(AR) $(LIBDIR)\$(SYSLIB).lib -+$(SYS).obj -+$(SYS)send.obj -+$(SYS)rcve.obj -+$(SYS)route.obj -+$(SYS)iface.obj -+$(SYS)prot.obj -+$(SYS)hdr.obj -+$(SYS)reas.obj;

obj: $(SYS).obj $(SYS)send.obj $(SYS)rcve.obj $(SYS)route.obj $(SYS)iface.obj $(SYS)prot.obj $(SYS)hdr.obj $(SYS)reas.obj

doc: $(SYS).man

clean:
    - $(RM) *.exe
    - $(RM) *.obj
    - $(RM) *.i
    - $(RM) *.lib
    - $(RM) *.man
    - $(RM) *.err
    - $(RM) *.bak

$(SYS).man: $(SYS).c
    $(MAN) -R:API  $(SYS).c > $(SYS).man

$(SYS).obj: $(SYS).c $(SYS).h 
$(SYS)send.obj: $(SYS)send.c $(SYS).h 
$(SYS)rcve.obj: $(SYS)rcve.c $(SYS).h 
$(SYS)route.obj: $(SYS)route.c $(SYS).h 
$(SYS)iface.obj: $(SYS)iface.c $(SYS).h 
$(SYS)prot.obj: $(SYS)prot.c $(SYS).h 
$(SYS)hdr.obj: $(SYS)hdr.c $(SYS).h 
$(SYS)reas.obj: $(SYS)reas.c $(SYS).h 


test.exe: test.obj test.ini
	$(LINK) test.obj $(SYSLIB)
	markexe windowcompat test.exe
