#include <memory.h>
#include <arp.h>
#include "ip.h"
#include "ipiface.h"
#include "iproute.h"

static WORD Ones(DWORD mask);

IP_ROUTE_ENTRY *ipRouteList = 0;



BOOLEAN IpRouteAdd( DWORD           addr,
                    DWORD           mask,
                    DWORD           addrNextHop,
                    MAC_IFACE       *iface,
                    WORD            metric)
{
    
    IP_ROUTE_ENTRY **p, *e;
    IP_IFACE *i;
    BOOLEAN found = FALSE;

    for (i=ipIfaceList; i!=0; i=i->next)
    {
        if (i->iface == iface)
            break;
    }
    
    if (i == 0)
        return FALSE;


    for (p = &ipRouteList; *p!=0; p=&(*p)->next)
    {
        if ((*p)->addr == addr)
        {
            found = TRUE;
            break;
        }
        if (Ones((*p)->mask < Ones(mask)))
            break;
    }
    
    if (found)
    {
        e = *p;
    }
    else
    {
        e = DnpapMalloc(sizeof(IP_ROUTE_ENTRY));
        if (e==0)
            return FALSE;
        e->next = *p;
        *p = e;
    }

    
    e->iface            = i;
    e->addr             = addr;
    e->addrNextHop      = addrNextHop;
    e->mask             = mask;
    e->metric           = metric;
    e->routingProto     = IP_ROUTE_PROTO_LOCAL;
    e->type             = IP_ROUTE_TYPE_REMOTE;

    return TRUE;
}



BOOLEAN IpRouteIsBroadcast(DWORD addr)
{
    return (addr == 0xffffffff || addr == 0);
}
                                                   


BOOLEAN IpRouteFind(DWORD addr, IP_ROUTE_ROUTE *route)
{
    IP_IFACE *i;
    IP_ROUTE_ENTRY *e;

    /* check local net (metric == 0) */
    
    for (i=ipIfaceList; i!=0; i=i->next)
    {
        if(i->up)
        {
            if((addr & i->mask) == i->addrNet)
            {
                route->iface        = i;
                route->addr         = addr;
                route->metric       = 16;
                route->broadcast    = (addr == i->addrBroadcast) ||
                                      (addr == i->addrNet);
                return TRUE;
            }
        }
    }

    /* check remote net (metric != 0) */

    for (e=ipRouteList; e!=0; e=e->next)
    {
        if(e->iface->up)
        {
            if((addr & e->mask) == e->addr)
            {
                route->iface        = e->iface;
                route->addr         = e->addrNextHop;
                route->metric       = e->metric;
                route->broadcast    = FALSE;
                return TRUE;
            }
        }
    }
    return FALSE;
}

DWORD IpRouteFindSrc(DWORD dst)
{
    IP_ROUTE_ROUTE r;
    DWORD          src;
    
    if (!IpRouteFind(dst, &r))
        src = 0L;
    else
        src = r.iface->addr;

    return src;
}



static WORD Ones(DWORD mask)
{
    WORD    c=0;
    DWORD   i=0x00000001;

    while(mask!=0)
    {
        if (mask & i)
            c++;
        mask>>=1;
    }
    return c;
}
