#include <memory.h>
#include <mac.h>
#include <ip.h>
#include "ether.h"


typedef struct _HDR HDR;

struct _HDR
{
    BYTE dst[6];
    BYTE src[6];
    WORD type;
};


static CHAIN *Encode(CHAIN *chain, MAC_HDR *hdr);
static CHAIN *Decode(CHAIN *chain, MAC_HDR *hdr);


MAC_TYPE etherMac =
{
    Encode,
    Decode,
    MAC_TYPE_ETHERNET_CSMACD
};




BOOLEAN EtherInit(void)
{
    static BOOLEAN init = FALSE;
    
    if (!init)
    {
        init = MacTypeRegister(&etherMac);
    }

    return init;
}





static CHAIN *Encode(CHAIN *chain, MAC_HDR *hdr)
{
    HDR *h;

    h=(HDR *)ChainPush(&chain, 14);
    if (h==0)
        return 0;
    memcpy(h->src, hdr->src, 6);
    memcpy(h->dst, hdr->dst, 6);
    h->type = IpH2NWord(hdr->type);
    return chain;
}


static CHAIN *Decode(CHAIN *chain, MAC_HDR *hdr)
{
    HDR *h;

    h=(HDR *)ChainPop(&chain, 14);
    if (h==0)
        return 0;
    hdr->src = h->src;
    hdr->dst = h->dst;
    hdr->type = IpN2HWord(h->type);
    return chain;
}
