#include <memory.h>
#include <stdio.h>
#define  INCL_BASE
#include <os2.h>
#include <dnpap.h>
#include <timer.h>
#include <block.h>
#include <mac.h>
#include <snor.h>
#include <ether.h>
#include "arp.h"



MAC_IFACE *iface;
ARP_DESCR arp;

static void DoArp(TIMER_DESCR *timer, ULONG now, void *parm);

void main(void)
{
    
    if (!TimerInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"TimerInit");
        DnpapExit(1);
    }

    if (!ArpInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"ArpInit");
        DnpapExit(1);
    }
    
    if (!EtherInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"EtherInit");
        DnpapExit(1);
    }
    
    if (!BlockInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"BlockInit");
        DnpapExit(1);
    }

    if (!SnorInit())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"SnorInit");
        DnpapExit(1);
    }
    
    iface = MacIfaceFind("NEUS0$");
    if (iface==0)
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"Iface NEUS0$ not found");
        DnpapExit(1);
    }
    
    printf("%02x:%02x:%02x:%02x:%02x:%02x\n",
        (WORD)iface->addr[0],
        (WORD)iface->addr[1],
        (WORD)iface->addr[2],
        (WORD)iface->addr[3],
        (WORD)iface->addr[4],
        (WORD)iface->addr[5]);

    arp.iface       = iface;
    arp.prot        = MAC_PROT_IP;
    memcpy(arp.addr, "\x82\xa1\x91\x04", 4);
    arp.addrLength  = 4;
    if (!ArpRegister(&arp))
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"ArpRegister");
        DnpapExit(1);
    }

    if (!TimerRegister(DoArp, 0, 30000L,
                TIMER_FOREVER, TIMER_TYPE_SKIP))
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"Could not register timer");
        DnpapExit(1);
    }
 
    if (!Block())
    {
        DnpapMessage(DMC_ERROR,TEST_ERROR,"Block");
        DnpapExit(1);
    }

    SnorExit();


}


static void DoArp(TIMER_DESCR *timer, ULONG now, void *parm)
{
    ArpRequest(iface, MAC_PROT_IP, "\x82\xa1\x90\x41", 0, 0);
    ArpRequest(iface, MAC_PROT_IP, "\x82\xa1\x01\x01", 0, 0);
}

