#ifndef MIBSUP_H
#define MIBSUP_H

#include <dnpap.h>
#include <snmp.h>

#define MIB_READ                0x01
#define MIB_WRITE               0x02

typedef struct _MIB_ELEMENT
{
    LONG        Id [SNMP_SIZE_OBJECTID];
    WORD        IdLen;
    WORD        (*Rqs) (SNMP_OBJECT *Obj, WORD IdLen);
    WORD        Type;
    WORD        Support;
} MIB_ELEMENT;

typedef struct _MIB_COMMUNITY
{
    BYTE        Comm [SNMP_SIZE_COMM];
    WORD        CommLen;
    WORD        Support;
} MIB_COMMUNITY;

typedef struct _MIB_RMON
{
    MIB_COMMUNITY   *Prf;
    WORD            PrfSze;
    MIB_ELEMENT     *Obj;
    WORD            ObjSze;
} MIB_RMON;

typedef struct _MIB_LOCAL MIB_LOCAL;
struct _MIB_LOCAL
{
    LONG        Index;
    MIB_LOCAL   *Next;
    VOID        *Data;
};

BOOLEAN     MibSimple   (SNMP_OBJECT *Obj, unsigned IdLen);
VOID        MibInit     (MIB_COMMUNITY *Prf, MIB_ELEMENT *Obj,
                        WORD PrfSize, WORD ObjSze);
MIB_LOCAL   * MibRmon   (SNMP_OBJECT *Obj, MIB_LOCAL *Local, 
                        WORD IdLen, WORD IdSize);
MIB_LOCAL   * MibInsert (SNMP_OBJECT *Obj, MIB_LOCAL **Local,
                        WORD IdLen, WORD IdSize);
BOOLEAN     MibRemove   (SNMP_OBJECT *Obj, MIB_LOCAL **Local, 
                        WORD IdLen, WORD IdSize);

#endif

