#ifndef _DHOSTC_H
#define _DHOSTC_H


#include <dnpap.h>
#include <snmp.h>

#include "hash.h"

/*  dhostx.h exposes the DNPAP_HOST structure  */
#include "dhostx.h"


typedef struct _DNPAP_HOST_CONTROL
{
    LONG            Index;
    LONG            Source[SNMP_SIZE_BUFINT];
    WORD            SourceLen;
    LONG            TableSize;
    ULONG           LastDeleteTime;
    BYTE            Owner[SNMP_SIZE_BUFCHR];
    WORD            OwnerLen;
    LONG            Status;

    /*  DNPAP extensions  */
    LONG            AcceptType;
    LONG            Matches;

    LONG            NrBuckets;
    ULONG           Interval;


    MAC_COLL        Coll;
    MAC_IFACE       *Iface;
    
    HashTable	    *Table;
    
    DNPAP_HOST	    *LexList;
    
    DNPAP_HOST	    *TimeList;
    DNPAP_HOST	    *TimeLast;
    DNPAP_HOST	    **TimeTable;
    BOOLEAN			TimeListUpdated;
    
    DNPAP_HOST      *LRUList;
    DNPAP_HOST      *LRULast;
    
} DNPAP_HOST_CONTROL;


BOOLEAN DnpapHostConfigInit(VOID);

BOOLEAN DnpapHostCInit(DNPAP_HOST_CONTROL *hostcontrol);
BOOLEAN DnpapHostCStart(DNPAP_HOST_CONTROL *hostcontrol);
BOOLEAN DnpapHostCStop(DNPAP_HOST_CONTROL *hostcontrol);

DNPAP_HOST* DnpapHostHashSearch(DNPAP_HOST_CONTROL *hostcontrol, DNPAP_HOST *host, WORD len);
DNPAP_HOST* DnpapHostHashSearch2(DNPAP_HOST_CONTROL *hostcontrol, SNMP_OBJECT *obj, WORD idlen);
DNPAP_HOST* DnpapHostTimeSearch(DNPAP_HOST_CONTROL *hostcontrol, SNMP_OBJECT *obj, WORD idlen);
LONG  DnpapHostSearchCreationOrder(DNPAP_HOST_CONTROL *hostcontrol, DNPAP_HOST *host);


#endif
