/************************************************************************
** MODULE INFORMATION **
************************
** FILE NAME:          filterc.c
** SYSTEM NAME:        beholder
** MODULE NAME:        filter
** ORIGINAL AUTHOR(S): M.F.B. de Greeve
** VERSION NUMBER:     1.0
** CREATION DATE:      1992/9/2
** DESCRIPTION:        collector for the filter-group
*************************************************************************/

#include <stdio.h>
#include <string.h>
#include <dnpap.h>
#include <mibsup.h>
#include <message.h>
#include <bitbyte.h>

#include "dfiltere.h"
#include "dfilterc.h"



BOOLEAN DnpapFilterCInit(DNPAP_FILTER *filter)
{
    filter->Channel = 1;
    filter->HostTable = 1;
    filter->Matrix = 1;

    return TRUE;
}


BOOLEAN DnpapFilterCStart(DNPAP_FILTER *filter)
{
BYTE *dataptr, *datamaskptr, *datanotmaskptr;

    /*  shift data and masks values a wee bit further (regarding PktDataOffset)  */
    if ((dataptr = ShiftBits(filter->PktData, filter->PktDataLen, 0, filter->PktDataLen, (WORD)filter->PktDataOffset % BITS(BYTE), 0)) == NULL)
        return FALSE;
    if ((datamaskptr = ShiftBits(filter->PktDataMask, filter->PktDataMaskLen, 0, filter->PktDataLen, (WORD)filter->PktDataOffset % BITS(BYTE), 1)) == NULL)
        return FALSE;
    if ((datanotmaskptr = ShiftBits(filter->PktDataNotMask, filter->PktDataNotMaskLen, 0, filter->PktDataLen, (WORD)filter->PktDataOffset % BITS(BYTE), 0)) == NULL)
        return FALSE;
    filter->PktData = dataptr;
    filter->PktDataMask = datamaskptr;
    filter->PktDataMaskLen = filter->PktDataLen;
    filter->PktDataNotMask = datanotmaskptr;
    filter->PktDataNotMaskLen = filter->PktDataLen;
    filter->PktDataNotMaskAllZero = BitsZero(filter->PktDataNotMask, filter->PktDataNotMaskLen, (WORD)filter->PktDataOffset % BITS(BYTE));
    return TRUE;
}


BOOLEAN DnpapFilterCStop(DNPAP_FILTER *filter)
{
    DnpapFree(filter->PktData);
    DnpapFree(filter->PktDataMask);
    DnpapFree(filter->PktDataNotMask);
    return TRUE;
}
