#ifndef _STATC_H
#define _STATC_H


#include <dnpap.h>
#include <mac.h>
#include <timer.h>
#include <snmp.h>


typedef struct _ETHER_STATS
{
    LONG            Source[SNMP_SIZE_BUFINT];
    WORD            SourceLen;
    MAC_STAT        BaseStat;
    ULONG           Octets; 
    ULONG           Pkts; 
    ULONG           Pkts64Octets; 
    ULONG           Pkts65to127Octets; 
    ULONG           Pkts128to255Octets; 
    ULONG           Pkts256to511Octets;
    ULONG           Pkts512to1023Octets;
    ULONG           Pkts1024to1518Octets;
    BYTE            Owner[SNMP_SIZE_BUFCHR];
    WORD            OwnerLen;
    LONG            Status;

    MAC_IFACE       *Iface;
    MAC_COLL        Coll;

} ETHER_STATS;


BOOLEAN StatCInit (ETHER_STATS *etherStats);
BOOLEAN StatCStart (ETHER_STATS *etherStats);
BOOLEAN StatCStop (ETHER_STATS *etherStats);


#endif
