/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       hostm.c
**     SYSTEM   NAME:       host
**     ORIGINAL AUTHOR(S):  M.F.B. de Greeve
**     VERSION  NUMBER:     1.0
**     CREATION DATE:       1992/9/25
**
** DESCRIPTION: host group of the RMON MIB
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/


#include <dnpap.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <message.h>
#include <mibsup.h>
#include <mac.h>

#include "hoste.h"
#include "hostc.h"
#include "host.h"


#define CONTROLINDEXSIZE   1
#define HOSTINDEXSIZE      7
#define TIMEINDEXSIZE      2


static MIB_LOCAL    *HostControlInstance = NULL;


static BOOLEAN RmonNext (SNMP_OBJECT *obj, MIB_LOCAL **local, WORD idlen, WORD indexsize, HOST **elem);

static HOST* HostGetFirstNext(HOST_CONTROL *hostcontrol, SNMP_OBJECT *obj, WORD idlen, BOOLEAN first);



BOOLEAN HostMInit(VOID)
{
    MessageConfig(HOST_ERROR, "Host");
    return HostConfigInit();
}


BOOLEAN RmonNext (SNMP_OBJECT *obj, MIB_LOCAL **local, WORD idlen, WORD indexsize, HOST **elem)
{
BOOLEAN first = FALSE;

    if (*local == NULL || indexsize < 1)
        return FALSE;

    if (obj->IdLen < idlen + indexsize)
    {
        switch (indexsize)
        {
        case HOSTINDEXSIZE:
            while (*local != NULL && (*elem = HostGetFirstNext((HOST_CONTROL*)(*local)->Data, obj, idlen, first)) == NULL)
            {
                first = TRUE;
                *local = (*local)->Next;
            }
            if (*local == NULL)
                return FALSE;
            obj->Id[idlen] = (*local)->Index;
            obj->IdLen = idlen + HOSTINDEXSIZE;
            break;
        case TIMEINDEXSIZE:
            while (*local != NULL && ((HOST_CONTROL*)(*local)->Data)->TableSize == 0)
                *local = (*local)->Next;
            if (*local == NULL)
                return FALSE;
            obj->Id[idlen] = (*local)->Index;
            obj->Id[idlen+1] = 1;
            obj->IdLen = idlen + TIMEINDEXSIZE;
            *elem = HostTimeSearch((HOST_CONTROL*)(*local)->Data, obj, idlen);
            break;
        case CONTROLINDEXSIZE:
            obj->Id[idlen] = (*local)->Index;
            obj->IdLen = idlen + CONTROLINDEXSIZE;
            break;
        }
        return TRUE;
    }
    else
    {
        switch (indexsize)
        {            
        case HOSTINDEXSIZE:
            while (*local != NULL && (*elem = HostGetFirstNext((HOST_CONTROL*)(*local)->Data, obj, idlen, first)) == NULL)
            {
                first = TRUE;
                *local = (*local)->Next;
            }
            if (*local == NULL)
                return FALSE;
            obj->Id[idlen] = (*local)->Index;
            obj->IdLen = idlen + HOSTINDEXSIZE;
            break;
        case TIMEINDEXSIZE:
            if (obj->Id[idlen+1] < ((HOST_CONTROL*)(*local)->Data)->TableSize)
            {
                obj->Id[idlen] = (*local)->Index;
                obj->Id[idlen+1]++;
                obj->IdLen = idlen + TIMEINDEXSIZE;
            	*elem = HostTimeSearch((HOST_CONTROL*)(*local)->Data, obj, idlen);
                break;
            }
            *local = (*local)->Next;
            while (*local != NULL && ((HOST_CONTROL*)(*local)->Data)->TableSize == 0)
                *local = (*local)->Next;
            if (*local == NULL)
                return FALSE;
            obj->Id[idlen] = (*local)->Index;
            obj->Id[idlen+1] = 1;
            obj->IdLen = idlen + TIMEINDEXSIZE;
            *elem = HostTimeSearch((HOST_CONTROL*)(*local)->Data, obj, idlen);
            break;
        case CONTROLINDEXSIZE:
            *local = (*local)->Next;
            if (*local == NULL)
                return FALSE;
            obj->Id[idlen] = (*local)->Index;
            obj->IdLen = idlen + CONTROLINDEXSIZE;
            break;
        }
        return TRUE;
    }
    return FALSE;
}


HOST *HostGetFirstNext(HOST_CONTROL *hostcontrol, SNMP_OBJECT *obj, WORD idlen, BOOLEAN first)
{
HOST host, *p;
INT i, len;

    if (hostcontrol->TableSize == 0)
        return NULL;

    if (first == TRUE)
    {           
        p = hostcontrol->LexList;
        for (i = 0; i < HOST_SZEADDR; i++)
            obj->Id[idlen+1+i] = (LONG)p->Address[i];
        obj->IdLen = idlen + HOSTINDEXSIZE;
        return p;
    }

    len = obj->IdLen-idlen-1;
    if (len < 0)
        len = 0;

    for (i = 0; i < len; i++)
        host.Address[i] = (BYTE)obj->Id[idlen+1+i];

    p = HostHashSearch(hostcontrol, &host, len);

    if (len == HOST_SZEADDR && p != NULL)
        p = p->LexNext;

    if (p != NULL)
    {
        for (i = 0; i < HOST_SZEADDR; i++)
            obj->Id[idlen+1+i] = (LONG)p->Address[i];
        obj->IdLen = idlen + HOSTINDEXSIZE;
    }
    return p;
}


WORD hostControlIndex (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, CONTROLINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, CONTROLINDEXSIZE, NULL) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        Obj->Syntax.LngInt = local->Index;
        return SNMP_NOERROR;
    }
}


WORD hostControlDataSource (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
HOST_CONTROL *data;
MAC_IFACE    *iface;

    if ((local = MibRmon(Obj, HostControlInstance, IdLen, CONTROLINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {           
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, CONTROLINDEXSIZE, NULL) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (HOST_CONTROL*) local->Data;
        memcpy (Obj->Syntax.BufInt, data->Source, data->SourceLen * sizeof (LONG));
        Obj->SyntaxLen = data->SourceLen;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
        data = (HOST_CONTROL*) local->Data;
        if (data->Status != SNMP_UNDERCREATION)
            return SNMP_READONLY;
        if (data->SourceLen != Obj->SyntaxLen ||
            memcmp(data->Source, Obj->Syntax.BufInt, (data->SourceLen-1) * sizeof (LONG)))
            return SNMP_BADVALUE;
        if ((iface = MacIfaceGet((WORD) Obj->Syntax.BufInt[Obj->SyntaxLen-1])) == NULL)
            return SNMP_BADVALUE;
        memcpy (data->Source, Obj->Syntax.BufInt, Obj->SyntaxLen * sizeof (LONG));
        data->SourceLen = Obj->SyntaxLen;
        data->Iface = iface;
        return SNMP_NOERROR;
    }
}


WORD hostControlTableSize (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
HOST_CONTROL *data;

    if ((local = MibRmon(Obj, HostControlInstance, IdLen, CONTROLINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, CONTROLINDEXSIZE, NULL) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (HOST_CONTROL*) local->Data;
        Obj->Syntax.LngInt = data->TableSize;
        return SNMP_NOERROR;
    }
}


WORD hostControlLastDeleteTime (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
HOST_CONTROL *data;

    if ((local = MibRmon(Obj, HostControlInstance, IdLen, CONTROLINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, CONTROLINDEXSIZE, NULL) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (HOST_CONTROL*) local->Data;
        Obj->Syntax.LngUns = data->LastDeleteTime;
        return SNMP_NOERROR;
    }
}


WORD hostControlOwner (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
HOST_CONTROL *data;

    if ((local = MibRmon(Obj, HostControlInstance, IdLen, CONTROLINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, CONTROLINDEXSIZE, NULL) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (HOST_CONTROL*) local->Data;
        memcpy (Obj->Syntax.BufChr, data->Owner, data->OwnerLen);
        Obj->SyntaxLen = data->OwnerLen;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
        data = (HOST_CONTROL*) local->Data;
        if (data->Status != SNMP_UNDERCREATION)
            return SNMP_READONLY;
        memcpy (data->Owner, Obj->Syntax.BufChr, Obj->SyntaxLen);
        data->OwnerLen = Obj->SyntaxLen;
        return SNMP_NOERROR;
    }
}


WORD hostControlStatus (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
HOST_CONTROL *data;

    local = MibRmon(Obj, HostControlInstance, IdLen, CONTROLINDEXSIZE);

    switch (Obj->Request)
    {
    case SNMP_PDU_GET:
        if (local == NULL)
        {
            Obj->Syntax.LngInt = SNMP_INVALID;
            return SNMP_NOSUCHNAME;
        }
        data = (HOST_CONTROL*) local->Data;
        Obj->Syntax.LngInt = data->Status;
        return SNMP_NOERROR;
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, CONTROLINDEXSIZE, NULL) == FALSE)
        {
            Obj->Syntax.LngInt = SNMP_INVALID;
            return SNMP_NOSUCHNAME;
        }
        data = (HOST_CONTROL*) local->Data;
        Obj->Syntax.LngInt = data->Status;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
        if (local == NULL)
        {
            switch (Obj->Syntax.LngInt)
            {
            case SNMP_CREATEREQUEST:
                if ((local = MibInsert(Obj, &HostControlInstance, IdLen, CONTROLINDEXSIZE)) == NULL)
                    return SNMP_GENERROR;
                if ((local->Data = DnpapMalloc(sizeof(HOST_CONTROL))) == NULL)
                    return SNMP_GENERROR;
                data = (HOST_CONTROL*) local->Data;
                if (HostCInit(data) == TRUE)
                {
                    data->Index = local->Index;
                    data->Status = SNMP_UNDERCREATION;
                    DnpapMessage(DMC_MESSAGE, HOST_CREATE, "host: collector %ld created", local->Index);
                    return SNMP_NOERROR;
                }
                DnpapFree(local->Data);
                MibRemove (Obj, &HostControlInstance, IdLen, CONTROLINDEXSIZE);
                return SNMP_GENERROR;
            default:
                return SNMP_NOSUCHNAME;
            }
        }
        data = (HOST_CONTROL*) local->Data;
        switch (data->Status)
        {
        case SNMP_UNDERCREATION:
            switch (Obj->Syntax.LngInt)
            {
            case SNMP_VALID:
                if (HostCStart(data) == TRUE)
                {
                    data->Status = SNMP_VALID;
                    DnpapMessage(DMC_MESSAGE, HOST_START, "host: collector %ld active", local->Index);
                    return SNMP_NOERROR;
                }
                return SNMP_GENERROR;
            case SNMP_INVALID:
                if (HostCStop(data) == TRUE)
                {
                    DnpapFree(local->Data);
                    DnpapMessage(DMC_MESSAGE, HOST_DESTROY, "host: collector %ld destroyed", local->Index);
                    if (MibRemove (Obj, &HostControlInstance, IdLen, CONTROLINDEXSIZE) == TRUE)
                        return SNMP_NOERROR;
                }
                return SNMP_GENERROR;
            default:
                return SNMP_BADVALUE;
            }
        case SNMP_VALID:
            switch (Obj->Syntax.LngInt)
            {
            case SNMP_VALID:
                return SNMP_NOERROR;
            case SNMP_INVALID:
                if (HostCStop(data) == TRUE)
                {
                    DnpapFree(local->Data);
                    DnpapMessage(DMC_MESSAGE, HOST_DESTROY, "host: collector %ld destroyed", local->Index);
                    if (MibRemove (Obj, &HostControlInstance, IdLen, CONTROLINDEXSIZE) == TRUE)
                        return SNMP_NOERROR;
                }
                return SNMP_GENERROR;
            default:
                return SNMP_BADVALUE;
            }
        }
    }
}


WORD hostAddress (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = HostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        memcpy (Obj->Syntax.BufChr, data->Address, Obj->SyntaxLen = HOST_SZEADDR);
        return SNMP_NOERROR;
    }
}


WORD hostCreationOrder (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = HostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngInt = HostSearchCreationOrder(local->Data, data);
        return SNMP_NOERROR;
    }
}


WORD hostIndex (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        Obj->Syntax.LngInt = local->Index;
        return SNMP_NOERROR;
    }
}


WORD hostInPkts (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = HostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->InPkts;
        return SNMP_NOERROR;
    }
}


WORD hostOutPkts (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = HostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutPkts;
        return SNMP_NOERROR;
    }
}


WORD hostInOctets (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = HostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->InOctets;
        return SNMP_NOERROR;
    }
}


WORD hostOutOctets (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = HostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutOctets;
        return SNMP_NOERROR;
    }
}


WORD hostOutErrors (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = HostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutErrors;
        return SNMP_NOERROR;
    }
}


WORD hostOutBroadcastPkts (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = HostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutBroadcastPkts;
        return SNMP_NOERROR;
    }
}


WORD hostOutMulticastPkts (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, HOSTINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, HOSTINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = HostHashSearch2(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutMulticastPkts;
        return SNMP_NOERROR;
    }
}


WORD hostTimeAddress (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = HostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        memcpy (Obj->Syntax.BufChr, data->Address, Obj->SyntaxLen = HOST_SZEADDR);
        return SNMP_NOERROR;
    }
}


WORD hostTimeCreationOrder (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = HostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngInt = Obj->Id[IdLen+1];
        return SNMP_NOERROR;
    }
}


WORD hostTimeIndex (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        Obj->Syntax.LngInt = local->Index;
        return SNMP_NOERROR;
    }
}


WORD hostTimeInPkts (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = HostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->InPkts;
        return SNMP_NOERROR;
    }
}


WORD hostTimeOutPkts (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = HostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutPkts;
        return SNMP_NOERROR;
    }
}


WORD hostTimeInOctets (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = HostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->InOctets;
        return SNMP_NOERROR;
    }
}


WORD hostTimeOutOctets (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = HostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutOctets;
        return SNMP_NOERROR;
    }
}


WORD hostTimeOutErrors (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = HostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutErrors;
        return SNMP_NOERROR;
    }
}


WORD hostTimeOutBroadcastPkts (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = HostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutBroadcastPkts;
        return SNMP_NOERROR;
    }
}


WORD hostTimeOutMulticastPkts (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL  *local = NULL;
HOST       *data = NULL;

    if ((local = MibRmon (Obj, HostControlInstance, IdLen, TIMEINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
        
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, TIMEINDEXSIZE, &data) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        if (data == NULL && (data = HostTimeSearch(local->Data, Obj, IdLen)) == NULL)
            return SNMP_NOSUCHNAME;
        Obj->Syntax.LngUns = data->OutMulticastPkts;
        return SNMP_NOERROR;
    }
}
