/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       event_u.c
**     SYSTEM   NAME:       event
**     ORIGINAL AUTHOR(S):  Richard Kooijman
**     VERSION  NUMBER:     0.99
**     CREATION DATE:       1992/9/28
**
** DESCRIPTION: user function hook for events
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header$";
#endif


#include <dnpap.h>
#include <channel.h>

#include "event_u.h"


static CHAR MODULE[] = "EventU";



/*****************************************************************
** NAME:        EventGenerated
** SYNOPSIS:    VOID EventGenerated(LONG eventindex)
** PARAMETERS:  eventindex: index of the event that was generated
** DESCRIPTION: called whenever an existing event is generated.
**              Interested applications can put their functions in
**              here so that they will be called too from then on.
** RETURNS:     nothing
** REMARKS:     see also GenerateEvent() in event_m
*******************************************************************/

VOID EventGenerated(LONG eventindex)
{
	/*  put here any functions that need to be called when an event is generated  */

	channelEventGenerated(eventindex);
}
