#ifndef _AGENT_H_
#define _AGENT_H_


#include <dnpap.h>
#include <snmp.h>

#define AGENT_ADDR_SIZE 16

typedef struct _AGENT_STAT AGENT_STAT;
typedef struct _AGENT_COMM AGENT_COMM;
typedef struct _AGENT_HOST AGENT_HOST;

struct _AGENT_STAT
{
    DWORD   datagrams;
    DWORD   errors;
};


struct _AGENT_COMM
{
    BYTE        comm[255];
    WORD        commLen;
    AGENT_HOST  *hostList;
    AGENT_COMM  *next;
};


struct _AGENT_HOST
{
    DWORD       addr;
    AGENT_HOST  *next;
};

BOOLEAN     AgentInit(void);
AGENT_STAT  *AgentStatistics(void);
BOOLEAN     AgentSendTrap (BYTE *comm, WORD commLen, WORD gen,
                       WORD spec, SNMP_OBJECT *list, WORD listLen);


#endif




