/**************************************\
*                                      *
*  Recursive Tree Size Report Utility  *
*  ----------------------------------  *
*  Written by: Matthew C. Davis        *
*  Written on: May 18th, 1999          *
*  Contact at: davis_mc@lrc.edu        *
*                                      *
*-Description--------------------------*
*                                      *
* Reports a list of directories and    *
* subdirectories to the screen as well *
* as the size of the directory's       *
* contents.  It tallies tree totals,   *
* and tags directories that exceed the *
* specified threshold in bytes.        *
*                                      *
*--------------------------------------*
*       HTTP://KO.THETAXI.COM          *
\**************************************/

Signal on Halt

Parse arg directory,tagsize

directory=strip(directory)
If directory='' then directory=directory()
If strip(tagsize)='' | Datatype(tagsize,'N')=0 Then tagsize=10000000

If Right(directory,1)='\' Then Directory=Left(directory,length(directory)-1)

Say 'Generating recursive consumption report for:'
Say '  'directory
Say '--------------------------------------------'
Tmp=rlist(directory,0,tagsize)
Say '--------------------------------------------'
Say 'GRAND TOTAL: 'Tmp' bytes'

Exit

/****************/
rlist: Procedure
   Parse Arg this,depth,thresh

   depth=depth+1
   Call charout ,'  '
   Do i=1 to depth-1
      Call charout ,' '
   End
                                        
   hit.0=0
   bytes=0
   Call SysFileTree this'\*','hit.','TF'
   Do i=1 to hit.0
      bytes=bytes+Word(hit.i,2)
   End
   Say this' - 'bytes' bytes'

   hit.0=0
   totalbytes=bytes
   Call sysFileTree this'\*','hit.','OD'
   Do i=1 to hit.0
      totalbytes=totalbytes+rlist(hit.i,depth,thresh)
   End
   
   If hit.0>0 Then Do
      If totalbytes>thresh Then Call charout ,'>>'
      Else Call charout ,'  '

      Do i=1 to depth-1
         Call charout ,' '
      End
      Say 'TOTAL: 'totalbytes' ('this')'
   End

Return totalbytes
/*****************************/
Halt:
Exit