/*
 * files.c - Operation on Reading Files
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <os2.h>

#include "qpager.h"

/*
 * List of Files
 */

static  FILEREC fileList = { 0 } ;

/*
 * filesInit - Initialize File Management
 */

int     filesInit(void)
{
    fileList.prev = &fileList ;
    fileList.next = &fileList ;
    
    return 0 ;
}

/*
 * filesDone - dispose file informations
 */

int     filesDone(void)
{
    FILEPTR p, prev, next ;
    
    while ((p = fileList.next) != &fileList) {
        /*
	 * Unlink from File List
	 */
	prev = p->prev ;
	next = p->next ;
	prev->next = next ;
	next->prev = prev ;

        /*
	 * Dispose File Information
	 */
        linesDone(p) ;      /* Dispose Lines */
        if (p->name) free(p->name) ;
	free(p) ;
    }
    return 0 ;
}

/*
 * filesAppend - Append a File into File List
 */

int     filesAppend(PUCHAR name, FILE *fp)
{
    FILEPTR np, prev, next ;
    PUCHAR  cp ;

    /*
     * Allocate New File Record
     */    
    np = (FILEPTR) malloc(sizeof(FILEREC))  ;
    cp = (PUCHAR)  malloc(strlen(name) + 2) ;
    if (np == NULL || cp == NULL) {
        if (np) free(np) ;
	if (cp) free(cp) ;
	return -1 ;
    }
    
    /*
     * Set File Informations
     */
    memset(np, 0, sizeof(FILEREC)) ;
    strcpy(cp, name) ;
    np->name = cp ;
    np->fp   = fp ;
    linesInit(np) ;

    /*
     * Link to File List
     */
    next = &fileList     ;
    prev = fileList.prev ;
    np->prev = prev ;
    np->next = next ;
    prev->next = np ;
    next->prev = np ;

    return 0 ;
}

/*
 * Refer to Files
 *      filesTop    refer to First File
 *      filesBot    refer to Last  File
 *      filesPrev   refer to Prev. File
 *      filesNext   refer to Next  File
 */
 
FILEPTR filesTop(void)
{
    FILEPTR p ;
    
    if ((p = fileList.next) == &fileList) {
        p = NULL ;
    }
    return p ;
}

FILEPTR filesBot(void)
{
    FILEPTR p ;

    if ((p = fileList.prev) == &fileList) {
        p = NULL ;
    }
    return p ;
}

FILEPTR filesPrev(FILEPTR fptr)
{
    FILEPTR p ;
    
    if (fptr == NULL) {
        return NULL ;
    }
    if ((p = fptr->prev) == &fileList) {
        p = NULL ;
    }
    return p ;
}

FILEPTR filesNext(FILEPTR fptr)
{
    FILEPTR p ;
    
    if (fptr == NULL) {
        return NULL ;
    }
    if ((p = fptr->next) == &fileList) {
        p = NULL ;
    }
    return p ;
}

/*
 * fill up Lines in a File
 */

#define STACKSIZE   (1024 * 16)

void    filesFill(FILEPTR fptr)
{
    if (fptr == NULL) {
        return ;
    }

    _beginthread(linesFill, 0, STACKSIZE, fptr) ;

    while (fptr->stat == IO_INIT) {
        DosSleep(100) ;
    }
    return ;
}


