/*********************************************************************/
/*                                                                   */
/*  This Program Written by Paul Edwards.                            */
/*  Released to the Public Domain                                    */
/*                                                                   */
/*********************************************************************/
/*********************************************************************/
/*                                                                   */
/*  crcxmgen - generate a CRC lookup table suitable for use by       */
/*  xmodem.  The CRC for xmodem is different from the CRC-16 and     */
/*  CCITT codes.  Why did I write this when there are so many other  */
/*  versions floating about?  Because I couldn't find a single one   */
/*  with an explicit Public Domain notice on it.                     */
/*                                                                   */
/*********************************************************************/

#include <stdio.h>

static unsigned int crcxm_tab[256];

int main(void)
{
  unsigned int x;
  unsigned int y;
  
  for (x=0;x<256;x++)
  {
    y = x ^ (x >> 4);
    crcxm_tab[x] = (y ^ (y << 5) ^ (y << 12)) & 0xffffU;
  }
  
  for (x=0;x<32;x++)
  {
    printf(" ");
    for (y=0;y<8;y++)
    {
      printf("0x%0.4XU, ",crcxm_tab[x*8+y]);
    }
    printf("\n");
  }
  return (0);
}
