/*********************************************************************/
/*                                                                   */
/*  This Program Written by Paul Edwards.                            */
/*  Released to the Public Domain                                    */
/*                                                                   */
/*********************************************************************/
/*********************************************************************/
/*                                                                   */
/*  crc16gen - generate a CRC16 lookup table.  This is NOT the CRC   */
/*  suitable for use by xmodem, and it is NOT the CCITT 16-bit CRC.  */
/*                                                                   */
/*********************************************************************/

#include <stdio.h>

static unsigned int crc16_tab[256];

int main(void)
{
  unsigned int x;
  unsigned int y;
  
  for (x=0;x<256;x++)
  {
    crc16_tab[x] = ((x << 6) ^ (x << 7)) & 0xffffU;
  }
  
  for (x=0;x<32;x++)
  {
    printf(" ");
    for (y=0;y<8;y++)
    {
      printf("0x%0.4XU, ",crc16_tab[x*8+y]);
    }
    printf("\n");
  }
  return (0);
}
