/* $Id: uniftime.h,v 1.1 2002/08/07 22:07:41 root Exp $ */

/* A unified timestamp = the number of hours since 01/01/1970. This yields
   enough precision and we still don't need to care about DST, TZ etc. in
   the long-term. */

#ifndef UNIFTIME_INCLUDED
#define UNIFTIME_INCLUDED

/* DOS timestamp macros */

#define get_tx(m,d,h,n) (((unsigned long)m<<21)+((unsigned long)d<<16)+((unsigned long)h<<11)+(n<<5))
#define get_tstamp(y,m,d,h,n,s) ((((unsigned long)(y-1980))<<25)+get_tx(m,d,h,n)+(s/2))

#define ts_year(ts)  ((unsigned int)((ts>>25)&0x7f)+1980)
#define ts_month(ts) ((unsigned int)(ts>>21)&0x0f)  /* 1..12 means Jan..Dec */
#define ts_day(ts)   ((unsigned int)(ts>>16)&0x1f)  /* 1..31 means 1st..31st */
#define ts_hour(ts)  ((unsigned int)(ts>>11)&0x1f)
#define ts_min(ts)   ((unsigned int)(ts>>5)&0x3f)
#define ts_sec(ts)   ((unsigned int)((ts&0x1f)*2))

/* Timestamp export structure for visual representation */

struct ts_exp
{
 unsigned char hour;                    /* 0...23 */
 unsigned char day;                     /* 1...31 */
 unsigned char month;                   /* 1...12 */
 unsigned long year;                    /* 1970+ */
};

/* Prototypes */

unsigned long dos2unif(unsigned long dos_time);
void exp_unif(struct ts_exp *pexp, unsigned long t);

#endif
