/* $Id: hddspd.h,v 1.1 2002/09/25 15:13:42 root Exp $
 *
 * Derived from HDDSPEED S.M.A.R.T. Monitor, (c) 1997 by Michael Radchenko
 */

#ifndef HDDSPD_INCLUDED
#define HDDSPD_INCLUDED

#pragma pack(1)

/* S.M.A.R.T. attributes snapshot. Note: TEC is calculated based on thresholds
   currently reported by the device - the structure below doesn't contain any
   threshold data! */

struct smart_rec
{
 char model[40];                        /* IDE model (raw) */
 char serial_num[20];                   /* IDE serial # (raw) */
 unsigned long start_date;              /* S.M.A.R.T. acquisition date (DOS) */
 DeviceAttributesData dev_attrs;        /* S.M.A.R.T. attributes */
}; /* Should be 576 bytes */

/* S.M.A.R.T. run-time data. */

struct smart_exec
{
 char firmware[8];                      /* Firmware revision (raw) */
 DeviceThresholdsData dev_thresholds;   /* S.M.A.R.T. thresholds */
};

/* Status flags for smart_rec.dev_attrs.Attribute[i].wFlags */

#define SF_CRITICAL       0x0001
#define SF_ONLINE         0x0002
#define SF_PERFORMANCE    0x0004
#define SF_ERROR_RATE     0x0008
#define SF_EVENT_COUNT    0x0010
#define SF_SELF_PRESERVE  0x0020

#pragma pack()

#endif
